/*    */ package org.jboss.aspects.remoting;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.aop.util.MethodHashing;
/*    */ import org.jboss.aop.util.PayloadKey;
/*    */ import org.jboss.remoting.InvokerLocator;
/*    */ 
/*    */ public class PojiProxy
/*    */   implements Serializable, InvocationHandler
/*    */ {
/*    */   private static final long serialVersionUID = 8054816523858555978L;
/*    */   private Object oid;
/*    */   private InvokerLocator uri;
/*    */   private Interceptor[] interceptors;
/*    */ 
/*    */   public PojiProxy(Object oid, InvokerLocator uri, Interceptor[] interceptors)
/*    */   {
/* 48 */     this.oid = oid;
/* 49 */     this.uri = uri;
/* 50 */     this.interceptors = interceptors;
/*    */   }
/*    */ 
/*    */   public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*    */   {
/* 55 */     long hash = MethodHashing.calculateHash(method);
/* 56 */     MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
/* 57 */     sri.setArguments(args);
/* 58 */     sri.getMetaData().addMetaData("DISPATCHER", "OID", this.oid, PayloadKey.AS_IS);
/* 59 */     sri.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", this.uri, PayloadKey.AS_IS);
/* 60 */     sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
/* 61 */     return sri.invokeNext();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.remoting.PojiProxy
 * JD-Core Version:    0.6.0
 */