/*     */ package org.jboss.aspects.remoting;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.proxy.ClassProxy;
/*     */ import org.jboss.aop.proxy.ClassProxyFactory;
/*     */ import org.jboss.aop.proxy.ProxyFactory;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.security.SecurityClientInterceptor;
/*     */ import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class Remoting
/*     */ {
/*     */   public static ClassProxy createRemoteProxy(Object objectId, Class clazz, String uri)
/*     */     throws Exception
/*     */   {
/*  53 */     return createRemoteProxy(objectId, clazz, new InvokerLocator(uri));
/*     */   }
/*     */ 
/*     */   public static ClassProxy createRemoteProxy(Object objectId, Class clazz, InvokerLocator locator)
/*     */     throws Exception
/*     */   {
/*  59 */     ClassProxy proxy = ClassProxyFactory.newInstance(clazz);
/*  60 */     makeRemotable(proxy, locator, objectId);
/*     */ 
/*  62 */     return proxy;
/*     */   }
/*     */ 
/*     */   public static org.jboss.aop.proxy.Proxy createRemoteProxy(Object objectId, ClassLoader loader, Class[] ifaces, InvokerLocator locator)
/*     */     throws Exception
/*     */   {
/*  78 */     GUID guid = new GUID();
/*  79 */     org.jboss.aop.proxy.Proxy proxy = ProxyFactory.createInterfaceProxy(guid, loader, ifaces);
/*  80 */     makeRemotable(proxy, locator, objectId);
/*  81 */     return proxy;
/*     */   }
/*     */ 
/*     */   public static org.jboss.aop.proxy.Proxy createRemoteProxy(Object objectId, ClassLoader loader, Class[] ifaces, InvokerLocator locator, List<Interceptor> interceptors, String subsystem)
/*     */     throws Exception
/*     */   {
/* 101 */     GUID guid = new GUID();
/* 102 */     org.jboss.aop.proxy.Proxy proxy = ProxyFactory.createInterfaceProxy(guid, loader, ifaces);
/* 103 */     makeRemotable(proxy, locator, objectId, interceptors, subsystem);
/* 104 */     return proxy;
/*     */   }
/*     */ 
/*     */   public static Object createPojiProxy(Object oid, Class[] interfaces, String uri)
/*     */     throws Exception
/*     */   {
/* 117 */     InvokerLocator locator = new InvokerLocator(uri);
/* 118 */     Interceptor[] interceptors = { IsLocalInterceptor.singleton, InvokeRemoteInterceptor.singleton };
/* 119 */     PojiProxy proxy = new PojiProxy(oid, locator, interceptors);
/* 120 */     return java.lang.reflect.Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, proxy);
/*     */   }
/*     */ 
/*     */   public static Object createPojiProxy(Object oid, Class[] interfaces, String uri, Interceptor[] interceptors)
/*     */     throws Exception
/*     */   {
/* 134 */     InvokerLocator locator = new InvokerLocator(uri);
/* 135 */     PojiProxy proxy = new PojiProxy(oid, locator, interceptors);
/* 136 */     return java.lang.reflect.Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, proxy);
/*     */   }
/*     */ 
/*     */   public static void makeRemotable(InstanceAdvised proxy, InvokerLocator locator, Object objectId)
/*     */   {
/* 152 */     ArrayList interceptors = new ArrayList();
/* 153 */     interceptors.add(IsLocalInterceptor.singleton);
/* 154 */     interceptors.add(SecurityClientInterceptor.singleton);
/* 155 */     interceptors.add(ClientTxPropagationInterceptor.singleton);
/* 156 */     interceptors.add(MergeMetaDataInterceptor.singleton);
/* 157 */     interceptors.add(InvokeRemoteInterceptor.singleton);
/* 158 */     makeRemotable(proxy, locator, objectId, interceptors, "AOP");
/*     */   }
/*     */ 
/*     */   public static void makeRemotable(InstanceAdvised proxy, InvokerLocator locator, Object objectId, List<Interceptor> interceptors, String subsystem)
/*     */   {
/* 173 */     InstanceAdvisor advisor = proxy._getInstanceAdvisor();
/* 174 */     for (Interceptor i : interceptors)
/* 175 */       advisor.insertInterceptor(i);
/* 176 */     advisor.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", locator, PayloadKey.AS_IS);
/*     */ 
/* 180 */     advisor.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", subsystem, PayloadKey.AS_IS);
/*     */ 
/* 184 */     advisor.getMetaData().addMetaData("DISPATCHER", "OID", objectId, PayloadKey.AS_IS);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.remoting.Remoting
 * JD-Core Version:    0.6.0
 */