/*    */ package org.jboss.aspects.remoting;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Map;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.ha.framework.server.HATarget;
/*    */ 
/*    */ public class ReplicantsManagerInterceptor
/*    */   implements Interceptor, ClusterConstants
/*    */ {
/*    */   private final Map families;
/*    */ 
/*    */   public ReplicantsManagerInterceptor(Map families)
/*    */   {
/* 41 */     this.families = families;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 46 */     return getClass().getName();
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 51 */     Object response = invocation.invokeNext();
/* 52 */     String clientFamily = (String)invocation.getMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILY");
/*    */ 
/* 54 */     HATarget target = (HATarget)this.families.get(clientFamily);
/* 55 */     if (target == null)
/*    */     {
/* 57 */       return response;
/*    */     }
/*    */ 
/* 60 */     Long clientViewId = (Long)invocation.getMetaData("CLUSTERED_REMOTING", "CLUSTER_VIEW_ID");
/* 61 */     if (clientViewId == null)
/*    */     {
/* 64 */       return response;
/*    */     }
/* 66 */     if (clientViewId.longValue() != target.getCurrentViewId())
/*    */     {
/* 68 */       invocation.addResponseAttachment("replicants", new ArrayList(target.getReplicants()));
/* 69 */       invocation.addResponseAttachment("viewId", new Long(target.getCurrentViewId()));
/*    */     }
/* 71 */     return response;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.remoting.ReplicantsManagerInterceptor
 * JD-Core Version:    0.6.0
 */