/*     */ package org.jboss.aspects.security;
/*     */ 
/*     */ import java.security.GeneralSecurityException;
/*     */ import java.security.Principal;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ 
/*     */ public class AuthenticationInterceptor
/*     */   implements Interceptor
/*     */ {
/*  40 */   protected Logger log = Logger.getLogger(getClass());
/*     */   protected AuthenticationManager authenticationManager;
/*     */ 
/*     */   public AuthenticationInterceptor(AuthenticationManager manager)
/*     */   {
/*  45 */     this.authenticationManager = manager;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  50 */     return "AuthenticationInterceptor";
/*     */   }
/*     */ 
/*     */   protected void handleGeneralSecurityException(GeneralSecurityException gse)
/*     */   {
/*  55 */     throw new SecurityException(gse.getMessage());
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*     */     try
/*     */     {
/*  66 */       authenticate(invocation);
/*     */     }
/*     */     catch (GeneralSecurityException gse)
/*     */     {
/*  70 */       handleGeneralSecurityException(gse);
/*     */     }
/*     */ 
/*  73 */     Object oldDomain = SecurityContext.currentDomain.get();
/*     */     try
/*     */     {
/*  76 */       SecurityContext.currentDomain.set(this.authenticationManager);
/*  77 */       Object localObject1 = invocation.invokeNext();
/*     */       RunAsIdentity callerRunAsIdentity;
/*     */       return localObject1;
/*     */     }
/*     */     finally
/*     */     {
/*  81 */       SecurityContext.currentDomain.set(oldDomain);
/*     */ 
/*  85 */       RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
/*  86 */       if ((this.authenticationManager == null) || (callerRunAsIdentity == null))
/*     */       {
/*  88 */         SecurityActions.popSubjectContext();
/*     */       }
/*  90 */       if (this.authenticationManager != null) {
/*  91 */         SecurityActions.clearSecurityContext();
/*     */       }
/*  93 */       if (invocation.getMetaData("security", "principal") != null)
/*     */       {
/*  95 */         SecurityActions.setPrincipal(null);
/*  96 */         SecurityActions.setCredential(null);
/*     */       }
/*     */     }
/*  98 */     throw localObject2;
/*     */   }
/*     */ 
/*     */   protected void authenticate(Invocation invocation) throws Exception
/*     */   {
/* 103 */     Principal principal = (Principal)invocation.getMetaData("security", "principal");
/* 104 */     Object credential = invocation.getMetaData("security", "credential");
/*     */ 
/* 106 */     if (principal == null)
/*     */     {
/* 108 */       principal = SecurityActions.getPrincipal();
/*     */     }
/* 110 */     if (credential == null)
/*     */     {
/* 112 */       credential = SecurityActions.getCredential();
/*     */     }
/*     */ 
/* 115 */     if (this.authenticationManager == null)
/*     */     {
/* 117 */       SecurityActions.pushSubjectContext(principal, credential, null);
/* 118 */       return;
/*     */     }
/*     */ 
/* 123 */     RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
/* 124 */     if (callerRunAsIdentity == null)
/*     */     {
/* 127 */       Subject subject = new Subject();
/* 128 */       if (!this.authenticationManager.isValid(principal, credential, subject))
/*     */       {
/* 136 */         Exception ex = SecurityActions.getContextException();
/* 137 */         if (ex != null) {
/* 138 */           throw ex;
/*     */         }
/* 140 */         String msg = "Authentication exception, principal=" + principal;
/* 141 */         SecurityException e = new SecurityException(msg);
/* 142 */         throw e;
/*     */       }
/*     */ 
/* 146 */       SecurityActions.pushSubjectContext(principal, credential, subject);
/* 147 */       SecurityActions.establishSecurityContext(this.authenticationManager.getSecurityDomain(), principal, credential, subject);
/*     */ 
/* 149 */       if (this.log.isTraceEnabled())
/*     */       {
/* 151 */         this.log.trace("Authenticated  principal=" + principal);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.AuthenticationInterceptor
 * JD-Core Version:    0.6.0
 */