/*    */ package org.jboss.aspects.security;
/*    */ 
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.AuthenticationManager;
/*    */ import org.jboss.security.RealmMapping;
/*    */ import org.jboss.security.RunAsIdentity;
/*    */ 
/*    */ public class RunAsSecurityInterceptor
/*    */   implements Interceptor
/*    */ {
/* 39 */   private static final Logger log = Logger.getLogger(RunAsSecurityInterceptor.class);
/*    */   protected AuthenticationManager securityManager;
/*    */   protected RealmMapping realmMapping;
/*    */ 
/*    */   public RunAsSecurityInterceptor(AuthenticationManager manager, RealmMapping realmMapping)
/*    */   {
/* 46 */     this.securityManager = manager;
/* 47 */     this.realmMapping = realmMapping;
/*    */   }
/*    */   public String getName() {
/* 50 */     return "RunAsSecurityInterceptor";
/*    */   }
/*    */ 
/*    */   protected RunAsIdentity getRunAsIdentity(Invocation invocation) {
/* 54 */     RunAsIdentity identity = (RunAsIdentity)invocation.getMetaData("security", "run-as");
/* 55 */     if (identity == null) identity = getAnnotationRunAsIdentity(invocation);
/* 56 */     return identity;
/*    */   }
/*    */ 
/*    */   protected RunAsIdentity getAnnotationRunAsIdentity(Invocation invocation)
/*    */   {
/* 61 */     RunAs runAs = (RunAs)invocation.resolveAnnotation(RunAs.class);
/* 62 */     if (runAs == null)
/*    */     {
/* 64 */       runAs = (RunAs)invocation.resolveClassAnnotation(RunAs.class);
/*    */     }
/* 66 */     if (runAs == null) return null;
/* 67 */     RunAsIdentity runAsRole = new RunAsIdentity(runAs.value(), null);
/* 68 */     return runAsRole;
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable {
/* 72 */     RunAsIdentity runAsRole = getRunAsIdentity(invocation);
/*    */ 
/* 76 */     if (runAsRole != null)
/*    */     {
/* 78 */       SecurityActions.pushRunAsIdentity(runAsRole);
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 83 */       Object localObject1 = invocation.invokeNext();
/*    */       return localObject1;
/*    */     }
/*    */     finally
/*    */     {
/* 87 */       if (runAsRole != null)
/*    */       {
/* 89 */         SecurityActions.popRunAsIdentity(); } 
/* 89 */     }throw localObject2;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.RunAsSecurityInterceptor
 * JD-Core Version:    0.6.0
 */