/*    */ package org.jboss.aspects.security;
/*    */ 
/*    */ import java.io.ObjectStreamException;
/*    */ import java.io.Serializable;
/*    */ import java.security.Principal;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.security.SecurityContext;
/*    */ 
/*    */ public final class SecurityClientInterceptor
/*    */   implements Interceptor, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -6366165968174741107L;
/* 39 */   public static final SecurityClientInterceptor singleton = new SecurityClientInterceptor();
/*    */ 
/* 40 */   public String getName() { return "SecurityClientInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation)
/*    */     throws Throwable
/*    */   {
/* 49 */     Principal principal = SecurityActions.getPrincipal();
/* 50 */     if (principal != null) invocation.getMetaData().addMetaData("security", "principal", principal);
/*    */ 
/* 52 */     Object credential = SecurityActions.getCredential();
/* 53 */     if (credential != null) invocation.getMetaData().addMetaData("security", "credential", credential);
/*    */ 
/* 56 */     SecurityContext sc = SecurityActions.getSecurityContext();
/* 57 */     if (sc == null)
/*    */     {
/* 59 */       sc = SecurityActions.createSecurityContext();
/* 60 */       SecurityActions.setSecurityContext(sc);
/*    */     }
/* 62 */     invocation.getMetaData().addMetaData("security", "context", sc);
/*    */     try
/*    */     {
/* 65 */       Object localObject1 = invocation.invokeNext();
/*    */       return localObject1; } finally { SecurityActions.setSecurityContext(sc); } throw localObject2;
/*    */   }
/*    */ 
/*    */   Object readResolve() throws ObjectStreamException
/*    */   {
/* 75 */     return singleton;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.SecurityClientInterceptor
 * JD-Core Version:    0.6.0
 */