/*     */ package org.jboss.aspects.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.HashSet;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class SecurityContext
/*     */ {
/*  40 */   protected static ThreadLocal currentDomain = new ThreadLocal();
/*     */ 
/*     */   public static ThreadLocal getCurrentDomain()
/*     */   {
/*  44 */     return currentDomain;
/*     */   }
/*     */ 
/*     */   public static Principal getCallerPrincipal()
/*     */   {
/*  53 */     return SecurityActions.getCallerPrincipal();
/*     */   }
/*     */ 
/*     */   public static Principal getCurrentPrincipal()
/*     */   {
/*  62 */     return SecurityActions.getPrincipal();
/*     */   }
/*     */ 
/*     */   public static boolean isCallerInRole(String roleName)
/*     */   {
/*  74 */     return isInRole(getCallerPrincipal(), roleName);
/*     */   }
/*     */ 
/*     */   public static boolean isCurrentInRole(String roleName)
/*     */   {
/*  87 */     return isInRole(getCurrentPrincipal(), roleName);
/*     */   }
/*     */ 
/*     */   private static boolean isInRole(Principal principal, String roleName)
/*     */   {
/*  92 */     RealmMapping rm = (RealmMapping)currentDomain.get();
/*  93 */     if (rm == null) return false;
/*     */ 
/*  95 */     HashSet set = new HashSet();
/*  96 */     set.add(new SimplePrincipal(roleName));
/*     */ 
/*  98 */     if ((principal instanceof RunAsIdentity))
/*     */     {
/* 100 */       return ((RunAsIdentity)principal).doesUserHaveRole(set);
/*     */     }
/*     */ 
/* 104 */     return rm.doesUserHaveRole(principal, set);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.SecurityContext
 * JD-Core Version:    0.6.0
 */