/*    */ package org.jboss.aspects.tx;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.aop.annotation.AnnotationElement;
/*    */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*    */ import org.jboss.aop.joinpoint.FieldReadInvocation;
/*    */ import org.jboss.aop.joinpoint.FieldWriteInvocation;
/*    */ import org.jboss.aspects.Injected;
/*    */ import org.jboss.tm.TransactionManagerLocator;
/*    */ 
/*    */ public class TransactionManagerInjector
/*    */ {
/*    */   public Object access(FieldReadInvocation invocation)
/*    */     throws Throwable
/*    */   {
/* 45 */     return TransactionManagerLocator.getInstance().locate();
/*    */   }
/*    */ 
/*    */   public Object access(FieldWriteInvocation invocation) throws Throwable
/*    */   {
/* 50 */     throw new RuntimeException("It is illegal to set an injected TransactionManager field.");
/*    */   }
/*    */ 
/*    */   public Object allocation(ConstructorInvocation invocation) throws Throwable
/*    */   {
/* 55 */     Object obj = invocation.invokeNext();
/*    */     try
/*    */     {
/* 59 */       Object[] arg = { TransactionManagerLocator.getInstance().locate() };
/* 60 */       Method[] methods = obj.getClass().getMethods();
/* 61 */       for (int i = 0; i < methods.length; i++)
/*    */       {
/* 63 */         if (methods[i].getParameterTypes().length != 1)
/*    */           continue;
/* 65 */         if (!methods[i].getParameterTypes()[0].equals(TransactionManager.class))
/*    */           continue;
/* 67 */         if (!AnnotationElement.isAnyAnnotationPresent(methods[i], Injected.class))
/*    */           continue;
/* 69 */         methods[i].invoke(obj, arg);
/*    */       }
/*    */ 
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 77 */       throw new RuntimeException(e);
/*    */     }
/* 79 */     return obj;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.tx.TransactionManagerInjector
 * JD-Core Version:    0.6.0
 */