/*     */ package org.jboss.aspects.tx;
/*     */ 
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class TxInterceptor
/*     */ {
/*  39 */   private static final Logger log = Logger.getLogger(TxInterceptor.class);
/*  40 */   private static final TxTimeoutReader txTimeoutReader = TxTimeoutReaderFactory.getTxTimeoutReader();
/*     */ 
/*     */   public static class Mandatory
/*     */     implements Interceptor
/*     */   {
/*     */     protected TransactionManager tm;
/*     */     protected TxPolicy policy;
/*     */     protected int timeout;
/*     */ 
/*     */     public Mandatory(TransactionManager tm, TxPolicy policy)
/*     */     {
/* 285 */       this(tm, policy, -1);
/*     */     }
/*     */ 
/*     */     public Mandatory(TransactionManager tm, TxPolicy policy, int timeout)
/*     */     {
/* 290 */       this.tm = tm;
/* 291 */       this.policy = policy;
/* 292 */       this.timeout = timeout;
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 297 */       return getClass().getName();
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation) throws Throwable
/*     */     {
/* 302 */       Transaction tx = this.tm.getTransaction();
/* 303 */       if (tx == null)
/*     */       {
/* 305 */         this.policy.throwMandatory(invocation);
/*     */       }
/* 307 */       return this.policy.invokeInCallerTx(invocation, tx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class RequiresNew
/*     */     implements Interceptor
/*     */   {
/*     */     protected TransactionManager tm;
/*     */     protected TxPolicy policy;
/*     */     protected int timeout;
/*     */ 
/*     */     public RequiresNew(TransactionManager tm, TxPolicy policy)
/*     */     {
/* 223 */       this(tm, policy, -1);
/*     */     }
/*     */ 
/*     */     public RequiresNew(TransactionManager tm, TxPolicy policy, int timeout)
/*     */     {
/* 228 */       this.tm = tm;
/* 229 */       this.policy = policy;
/* 230 */       this.timeout = timeout;
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 235 */       return getClass().getName();
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation) throws Throwable
/*     */     {
/* 240 */       int oldTimeout = TxInterceptor.txTimeoutReader.getTransactionTimeOut(this.tm);
/*     */       try
/*     */       {
/* 244 */         if ((this.timeout != -1) && (this.tm != null))
/*     */         {
/* 246 */           this.tm.setTransactionTimeout(this.timeout);
/*     */         }
/*     */ 
/* 249 */         Transaction tx = this.tm.getTransaction();
/* 250 */         if (tx != null)
/*     */         {
/* 252 */           this.tm.suspend();
/*     */           try
/*     */           {
/* 255 */             localObject1 = this.policy.invokeInOurTx(invocation, this.tm);
/*     */ 
/* 259 */             this.tm.resume(tx);
/*     */ 
/* 269 */             if (this.tm != null)
/*     */             {
/* 271 */               this.tm.setTransactionTimeout(oldTimeout); } return localObject1;
/*     */           }
/*     */           finally
/*     */           {
/* 259 */             this.tm.resume(tx);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 264 */         Object localObject1 = this.policy.invokeInOurTx(invocation, this.tm);
/*     */         return localObject1;
/*     */       }
/*     */       finally
/*     */       {
/* 269 */         if (this.tm != null)
/*     */         {
/* 271 */           this.tm.setTransactionTimeout(oldTimeout); } 
/* 271 */       }throw localObject3;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Required
/*     */     implements Interceptor
/*     */   {
/* 160 */     private static final Logger log = Logger.getLogger(Required.class);
/*     */     protected TransactionManager tm;
/*     */     protected TxPolicy policy;
/*     */     protected int timeout;
/*     */ 
/*     */     public Required(TransactionManager tm, TxPolicy policy)
/*     */     {
/* 168 */       this(tm, policy, -1);
/*     */     }
/*     */ 
/*     */     public Required(TransactionManager tm, TxPolicy policy, int timeout)
/*     */     {
/* 173 */       this.tm = tm;
/* 174 */       this.policy = policy;
/* 175 */       this.timeout = timeout;
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation) throws Throwable
/*     */     {
/* 180 */       int oldTimeout = TxInterceptor.txTimeoutReader.getTransactionTimeOut(this.tm);
/*     */       try
/*     */       {
/* 184 */         if ((this.timeout != -1) && (this.tm != null))
/*     */         {
/* 186 */           this.tm.setTransactionTimeout(this.timeout);
/*     */         }
/*     */ 
/* 189 */         Transaction tx = this.tm.getTransaction();
/*     */ 
/* 191 */         if (tx == null)
/*     */         {
/* 193 */           localObject1 = this.policy.invokeInOurTx(invocation, this.tm);
/*     */           return localObject1;
/*     */         }
/* 197 */         Object localObject1 = this.policy.invokeInCallerTx(invocation, tx);
/*     */         return localObject1;
/*     */       }
/*     */       finally
/*     */       {
/* 202 */         if (this.tm != null)
/*     */         {
/* 204 */           this.tm.setTransactionTimeout(oldTimeout); } 
/* 204 */       }throw localObject2;
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 211 */       return getClass().getName();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Supports
/*     */     implements Interceptor
/*     */   {
/*     */     protected TransactionManager tm;
/*     */     protected TxPolicy policy;
/*     */     protected int timeout;
/*     */ 
/*     */     public Supports(TransactionManager tm, TxPolicy policy)
/*     */     {
/* 130 */       this(tm, policy, -1);
/*     */     }
/*     */ 
/*     */     public Supports(TransactionManager tm, TxPolicy policy, int timeout)
/*     */     {
/* 135 */       this.tm = tm;
/* 136 */       this.policy = policy;
/* 137 */       this.timeout = timeout;
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation) throws Throwable
/*     */     {
/* 142 */       if (this.tm.getTransaction() == null)
/*     */       {
/* 144 */         return this.policy.invokeInNoTx(invocation);
/*     */       }
/*     */ 
/* 148 */       return this.policy.invokeInCallerTx(invocation, this.tm.getTransaction());
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 154 */       return getClass().getName();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class NotSupported
/*     */     implements Interceptor
/*     */   {
/*     */     protected TransactionManager tm;
/*     */     protected TxPolicy policy;
/*     */     protected int timeout;
/*     */ 
/*     */     public NotSupported(TransactionManager tm, TxPolicy policy)
/*     */     {
/*  83 */       this(tm, policy, -1);
/*     */     }
/*     */ 
/*     */     public NotSupported(TransactionManager tm, TxPolicy policy, int timeout)
/*     */     {
/*  88 */       this.tm = tm;
/*  89 */       this.policy = policy;
/*  90 */       this.timeout = timeout;
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation)
/*     */       throws Throwable
/*     */     {
/*  96 */       Transaction tx = this.tm.getTransaction();
/*  97 */       if (tx != null)
/*     */       {
/*  99 */         this.tm.suspend();
/*     */         try
/*     */         {
/* 102 */           Object localObject1 = this.policy.invokeInNoTx(invocation);
/*     */           return localObject1; } finally { this.tm.resume(tx);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 112 */       return this.policy.invokeInNoTx(invocation);
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 118 */       return getClass().getName();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Never
/*     */     implements Interceptor
/*     */   {
/*     */     protected TransactionManager tm;
/*     */     protected TxPolicy policy;
/*     */     protected int timeout;
/*     */ 
/*     */     public Never(TransactionManager tm, TxPolicy policy)
/*     */     {
/*  50 */       this(tm, policy, -1);
/*     */     }
/*     */ 
/*     */     public Never(TransactionManager tm, TxPolicy policy, int timeout)
/*     */     {
/*  55 */       this.tm = tm;
/*  56 */       this.policy = policy;
/*  57 */       this.timeout = timeout;
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation) throws Throwable
/*     */     {
/*  62 */       if (this.tm.getTransaction() != null)
/*     */       {
/*  64 */         throw new IllegalStateException("Transaction present on server in Never call");
/*     */       }
/*  66 */       return this.policy.invokeInNoTx(invocation);
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/*  71 */       return getClass().getName();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.tx.TxInterceptor
 * JD-Core Version:    0.6.0
 */