/*     */ package org.jboss.aspects.tx;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Random;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.deadlock.ApplicationDeadlockException;
/*     */ 
/*     */ public class TxPolicy
/*     */ {
/*  54 */   protected static final Logger log = Logger.getLogger(TxPolicy.class);
/*     */ 
/*  56 */   public static int MAX_RETRIES = 5;
/*  57 */   public static Random random = new Random();
/*     */ 
/*     */   public void throwMandatory(Invocation invocation)
/*     */   {
/*  61 */     throw new RuntimeException("Transaction is mandatory.");
/*     */   }
/*     */ 
/*     */   public Object invokeInNoTx(Invocation invocation) throws Throwable
/*     */   {
/*  66 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object invokeInOurTx(Invocation invocation, TransactionManager tm) throws Throwable
/*     */   {
/*  71 */     for (int i = 0; i < MAX_RETRIES; i++)
/*     */     {
/*  73 */       tm.begin();
/*  74 */       Transaction tx = tm.getTransaction();
/*     */       try
/*     */       {
/*     */         try
/*     */         {
/*  79 */           Object localObject1 = invocation.invokeNext();
/*     */           return localObject1;
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/*  83 */           handleExceptionInOurTx(invocation, t, tx);
/*     */         }
/*     */         finally
/*     */         {
/*  87 */           endTransaction(tm, tx);
/*     */         }
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/*  92 */         ApplicationDeadlockException deadlock = ApplicationDeadlockException.isADE(ex);
/*  93 */         if (deadlock != null)
/*     */         {
/*  95 */           if ((!deadlock.retryable()) || (i + 1 >= MAX_RETRIES))
/*     */           {
/*  98 */             throw deadlock;
/*     */           }
/* 100 */           log.warn(deadlock.getMessage() + " retrying " + (i + 1));
/*     */ 
/* 102 */           Thread.sleep(random.nextInt(1 + i), random.nextInt(1000));
/*     */         }
/*     */         else
/*     */         {
/* 106 */           throw ex;
/*     */         }
/*     */       }
/*     */     }
/* 110 */     throw new RuntimeException("UNREACHABLE");
/*     */   }
/*     */ 
/*     */   public void handleExceptionInOurTx(Invocation invocation, Throwable t, Transaction tx)
/*     */     throws Throwable
/*     */   {
/* 117 */     rethrowApplicationException(invocation, t);
/* 118 */     setRollbackOnly(tx);
/* 119 */     throw t;
/*     */   }
/*     */ 
/*     */   public Object invokeInCallerTx(Invocation invocation, Transaction tx) throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 126 */       return invocation.invokeNext();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 130 */       handleInCallerTx(invocation, t, tx);
/*     */     }
/* 132 */     throw new RuntimeException("UNREACHABLE");
/*     */   }
/*     */ 
/*     */   public void handleInCallerTx(Invocation invocation, Throwable t, Transaction tx)
/*     */     throws Throwable
/*     */   {
/* 138 */     rethrowApplicationException(invocation, t);
/* 139 */     setRollbackOnly(tx);
/* 140 */     throw t;
/*     */   }
/*     */ 
/*     */   public void endTransaction(TransactionManager tm, Transaction tx)
/*     */   {
/*     */     try
/*     */     {
/* 160 */       if (tx != tm.getTransaction())
/*     */       {
/* 162 */         throw new IllegalStateException("Wrong tx on thread: expected " + tx + ", actual " + tm.getTransaction());
/*     */       }
/*     */ 
/* 165 */       if (tx.getStatus() == 1)
/*     */       {
/* 167 */         tm.rollback();
/*     */       }
/*     */       else
/*     */       {
/* 175 */         tm.commit();
/*     */       }
/*     */     }
/*     */     catch (RollbackException e)
/*     */     {
/* 180 */       handleEndTransactionException(e);
/*     */     }
/*     */     catch (HeuristicMixedException e)
/*     */     {
/* 184 */       handleEndTransactionException(e);
/*     */     }
/*     */     catch (HeuristicRollbackException e)
/*     */     {
/* 188 */       handleEndTransactionException(e);
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 192 */       handleEndTransactionException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleEndTransactionException(Exception e)
/*     */   {
/* 198 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly(Transaction tx)
/*     */   {
/*     */     try
/*     */     {
/* 212 */       tx.setRollbackOnly();
/*     */     }
/*     */     catch (SystemException ex)
/*     */     {
/* 216 */       log.error("SystemException while setting transaction for rollback only", ex);
/*     */     }
/*     */     catch (IllegalStateException ex)
/*     */     {
/* 221 */       log.error("IllegalStateException while setting transaction for rollback only", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rethrowApplicationException(Invocation inv, Throwable e)
/*     */     throws Throwable
/*     */   {
/* 236 */     Object applicationExceptions = inv.getMetaData("transaction", "application-exceptions");
/* 237 */     if (applicationExceptions == null) return;
/*     */     Class[] applicationExceptionsList;
/*     */     Class[] applicationExceptionsList;
/* 239 */     if ((applicationExceptions instanceof String))
/*     */     {
/* 241 */       ArrayList tmpList = new ArrayList();
/* 242 */       String aes = (String)applicationExceptions;
/* 243 */       aes = aes.trim();
/* 244 */       StringTokenizer tokenizer = new StringTokenizer(aes, ",");
/* 245 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 247 */         String token = tokenizer.nextToken().trim();
/* 248 */         Class excClass = Thread.currentThread().getContextClassLoader().loadClass(token);
/* 249 */         tmpList.add(excClass);
/*     */       }
/* 251 */       applicationExceptionsList = (Class[])(Class[])tmpList.toArray(new Class[tmpList.size()]);
/*     */     }
/*     */     else
/*     */     {
/* 255 */       applicationExceptionsList = (Class[])(Class[])applicationExceptions;
/*     */     }
/* 257 */     for (int i = 0; i < applicationExceptionsList.length; i++)
/*     */     {
/* 259 */       if (!applicationExceptionsList[i].isInstance(e)) continue; throw e;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.tx.TxPolicy
 * JD-Core Version:    0.6.0
 */