/*    */ package org.jboss.aspects.tx;
/*    */ 
/*    */ import javax.transaction.Transaction;
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.tm.TransactionManagerLocator;
/*    */ import org.jboss.tm.TransactionPropagationContextImporter;
/*    */ import org.jboss.tm.TransactionPropagationContextUtil;
/*    */ 
/*    */ public class TxPropagationInterceptor
/*    */   implements Interceptor
/*    */ {
/*    */   private TransactionManager tm;
/*    */ 
/*    */   public TxPropagationInterceptor(TransactionManager tm)
/*    */   {
/* 43 */     this.tm = tm;
/*    */   }
/*    */ 
/*    */   public TxPropagationInterceptor()
/*    */   {
/* 48 */     this.tm = TransactionManagerLocator.getInstance().locate();
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 53 */     return "TxPropagationInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 58 */     Object tpc = invocation.getMetaData(ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT, ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT);
/* 59 */     if (tpc != null)
/*    */     {
/* 61 */       Transaction tx = this.tm.getTransaction();
/* 62 */       if (tx != null) throw new RuntimeException("cannot import a transaction context when a transaction is already associated with the thread");
/* 63 */       Transaction importedTx = TransactionPropagationContextUtil.getTPCImporter().importTransactionPropagationContext(tpc);
/* 64 */       this.tm.resume(importedTx);
/*    */       try
/*    */       {
/* 67 */         Object localObject1 = invocation.invokeNext();
/*    */         return localObject1; } finally { this.tm.suspend();
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 76 */     return invocation.invokeNext();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.tx.TxPropagationInterceptor
 * JD-Core Version:    0.6.0
 */