/*    */ package org.jboss.aspects.versioned;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.HashMap;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.aop.util.reference.MethodPersistentReference;
/*    */ 
/*    */ public class CollectionStateChangeInterceptor
/*    */   implements Interceptor
/*    */ {
/*    */   protected CollectionStateManager manager;
/*    */ 
/*    */   public CollectionStateChangeInterceptor(CollectionStateManager manager)
/*    */   {
/* 43 */     this.manager = manager;
/*    */   }
/*    */   public String getName() {
/* 46 */     return "CollectionChangeInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation)
/*    */     throws Throwable
/*    */   {
/* 54 */     if ((invocation instanceof MethodInvocation))
/*    */     {
/* 56 */       MethodInvocation methodInvocation = (MethodInvocation)invocation;
/* 57 */       long methodHash = methodInvocation.getMethodHash();
/* 58 */       Method managerMethod = this.manager.isManagerMethod(methodHash);
/* 59 */       if (managerMethod != null)
/*    */       {
/* 61 */         Object[] args = methodInvocation.getArguments();
/* 62 */         return managerMethod.invoke(this.manager, args);
/*    */       }
/* 64 */       Object target = methodInvocation.getTargetObject();
/* 65 */       Method method = methodInvocation.getMethod();
/* 66 */       if (method == null)
/*    */       {
/* 68 */         HashMap methodMap = this.manager.getMethodMap();
/* 69 */         MethodPersistentReference ref = (MethodPersistentReference)methodMap.get(new Long(methodHash));
/* 70 */         method = (Method)ref.get();
/*    */       }
/* 72 */       return method.invoke(target, methodInvocation.getArguments());
/*    */     }
/* 74 */     return invocation.invokeNext();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.CollectionStateChangeInterceptor
 * JD-Core Version:    0.6.0
 */