/*    */ package org.jboss.aspects.versioned;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.jboss.aop.InstanceAdvised;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public class DistributedFieldUpdate
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -8249659475610689146L;
/*    */   protected Object val;
/*    */   protected long version;
/*    */   protected int index;
/*    */ 
/*    */   public DistributedFieldUpdate()
/*    */   {
/*    */   }
/*    */ 
/*    */   public DistributedFieldUpdate(Object val, long version, int index)
/*    */   {
/* 37 */     setValue(val);
/* 38 */     this.version = version;
/* 39 */     this.index = index;
/*    */   }
/* 41 */   public long getVersionId() { return this.version; } 
/* 42 */   public void setVersionId(long newId) { this.version = newId; } 
/* 43 */   public int getFieldIndex() { return this.index;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object obj)
/*    */   {
/* 48 */     DistributedFieldUpdate update = (DistributedFieldUpdate)obj;
/* 49 */     return update.index == this.index;
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 54 */     return this.index;
/*    */   }
/*    */ 
/*    */   public Object getValue()
/*    */   {
/* 60 */     if ((this.val instanceof VersionReference))
/*    */     {
/* 62 */       return ((VersionReference)this.val).get();
/*    */     }
/* 64 */     return this.val;
/*    */   }
/*    */ 
/*    */   public void setValue(Object newVal) {
/* 68 */     if ((newVal instanceof InstanceAdvised))
/*    */     {
/* 70 */       InstanceAdvised advised = (InstanceAdvised)newVal;
/* 71 */       GUID guid = VersionManager.getGUID(advised);
/* 72 */       if (guid != null)
/*    */       {
/* 75 */         this.val = new VersionReference(guid, advised);
/* 76 */         return;
/*    */       }
/*    */     }
/*    */ 
/* 80 */     this.val = newVal;
/*    */   }
/*    */ 
/*    */   public Object getNonDereferencedValue() {
/* 84 */     return this.val;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.DistributedFieldUpdate
 * JD-Core Version:    0.6.0
 */