/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class LocalSynchronizationManager
/*     */   implements SynchronizationManager
/*     */ {
/*  49 */   protected static Logger log = Logger.getLogger(DistributedSynchronizationManager.class);
/*  50 */   protected TransactionLocal txSynch = new TransactionLocal();
/*     */ 
/*  52 */   protected Object tableLock = new Object();
/*  53 */   protected Hashtable objectTable = new Hashtable();
/*  54 */   protected Hashtable stateTable = new Hashtable();
/*     */   protected DistributedVersionManager versionManager;
/*     */ 
/*     */   public LocalSynchronizationManager(DistributedVersionManager versionManager)
/*     */   {
/*  59 */     this.versionManager = versionManager;
/*     */   }
/*     */ 
/*     */   public Object getObject(GUID guid)
/*     */   {
/*  64 */     synchronized (this.tableLock)
/*     */     {
/*  66 */       WeakReference ref = (WeakReference)this.objectTable.get(guid);
/*  67 */       if (ref != null)
/*     */       {
/*  69 */         return ref.get();
/*     */       }
/*  71 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void putObject(GUID guid, Object obj)
/*     */   {
/*  77 */     synchronized (this.tableLock)
/*     */     {
/*  79 */       this.objectTable.put(guid, new WeakReference(obj));
/*     */     }
/*     */   }
/*     */ 
/*     */   public DistributedState getState(GUID guid)
/*     */   {
/*  85 */     synchronized (this.tableLock)
/*     */     {
/*  87 */       return (DistributedState)this.stateTable.get(guid);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void putState(GUID guid, Object obj)
/*     */   {
/*  93 */     synchronized (this.tableLock)
/*     */     {
/*  95 */       this.stateTable.put(guid, obj);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void registerUpdate(Transaction tx, DistributedState state)
/*     */     throws Exception
/*     */   {
/* 102 */     if (tx == null) return;
/* 103 */     GUID guid = state.getGUID();
/* 104 */     DistributedStateSynchronization synch = (DistributedStateSynchronization)this.txSynch.get(tx);
/* 105 */     if (synch == null)
/*     */     {
/* 107 */       synch = new DistributedStateSynchronization(tx);
/* 108 */       this.txSynch.set(tx, synch);
/* 109 */       tx.registerSynchronization(synch);
/* 110 */       synch.updates().put(guid, state);
/* 111 */       return;
/*     */     }
/* 113 */     if (synch.updates().containsKey(guid)) return;
/* 114 */     synch.updates().put(guid, state);
/*     */   }
/*     */ 
/*     */   public void createObjects(List newObjects) throws Exception
/*     */   {
/* 119 */     log.trace("in create Objects");
/* 120 */     for (int i = 0; i < newObjects.size(); i++)
/*     */     {
/* 122 */       DistributedState state = (DistributedState)newObjects.get(i);
/* 123 */       synchronized (this.tableLock)
/*     */       {
/* 125 */         this.objectTable.put(state.getGUID(), new WeakReference(state.getObject()));
/* 126 */         this.stateTable.put(state.getGUID(), state);
/*     */       }
/*     */     }
/* 129 */     sendNewObjects(newObjects);
/*     */   }
/*     */ 
/*     */   public void sendNewObjects(List newObjects)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void sendClusterUpdatesAndRelease(GUID globalTxId, List clusterUpdates)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void acquireRemoteLocks(GUID globalTxId, List guids)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void noTxUpdate(DistributedUpdate update) throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void releaseHeldLocks(List locks)
/*     */   {
/* 153 */     log.trace("releaseHeldLocks");
/* 154 */     for (int i = 0; i < locks.size(); i++)
/*     */     {
/*     */       try
/*     */       {
/* 158 */         DistributedState state = (DistributedState)locks.get(i);
/* 159 */         state.releaseWriteLock();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 166 */     log.trace("end releaseHeldLocks"); } 
/*     */   private final class DistributedStateSynchronization implements Synchronization { final Transaction tx;
/* 172 */     HashMap managers = new HashMap();
/*     */     ArrayList locks;
/* 174 */     boolean optimisticLockPassed = false;
/*     */     ArrayList clusterUpdates;
/*     */     GUID globalTxId;
/*     */ 
/* 179 */     public DistributedStateSynchronization(Transaction tx) { this.tx = tx; }
/*     */ 
/*     */     public HashMap updates() {
/* 182 */       return this.managers;
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/* 187 */       ArrayList guidList = new ArrayList(this.managers.keySet());
/*     */ 
/* 190 */       Collections.sort(guidList);
/* 191 */       this.clusterUpdates = new ArrayList();
/* 192 */       this.locks = new ArrayList();
/*     */       try
/*     */       {
/* 195 */         for (int i = 0; i < guidList.size(); i++)
/*     */         {
/* 197 */           GUID guid = (GUID)guidList.get(i);
/* 198 */           DistributedState manager = (DistributedState)this.managers.get(guid);
/* 199 */           LocalSynchronizationManager.log.trace("acquiring writelock in beforecompletion");
/* 200 */           manager.acquireWriteLock();
/*     */ 
/* 202 */           this.locks.add(manager);
/* 203 */           manager.checkOptimisticLock(this.tx);
/* 204 */           this.clusterUpdates.add(manager.createTxUpdate(this.tx));
/*     */         }
/* 206 */         this.globalTxId = new GUID();
/* 207 */         LocalSynchronizationManager.this.acquireRemoteLocks(this.globalTxId, guidList);
/*     */       }
/*     */       catch (RuntimeException ex)
/*     */       {
/* 212 */         LocalSynchronizationManager.this.releaseHeldLocks(this.locks);
/* 213 */         throw ex;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 217 */         throw new RuntimeException(ex);
/*     */       }
/* 219 */       this.optimisticLockPassed = true;
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 225 */       if (status != 4)
/*     */       {
/* 227 */         Iterator it = this.managers.values().iterator();
/* 228 */         while (it.hasNext())
/*     */         {
/* 230 */           DistributedState manager = (DistributedState)it.next();
/*     */           try
/*     */           {
/* 233 */             manager.mergeState(this.tx);
/*     */           }
/*     */           catch (Exception ignored)
/*     */           {
/* 239 */             LocalSynchronizationManager.log.error("afterCompletion failed on mergeState, cache is probably inconsistent and should be flushed", ignored);
/*     */           }
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 245 */           LocalSynchronizationManager.this.sendClusterUpdatesAndRelease(this.globalTxId, this.clusterUpdates);
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/* 251 */           LocalSynchronizationManager.log.error("afterCompletion failed on mergeState, cache is probably inconsistent and should be flushed", ignored);
/*     */         }
/*     */       }
/* 254 */       if (this.optimisticLockPassed)
/*     */       {
/* 256 */         LocalSynchronizationManager.log.trace("afterCompletion releaseHeldLocks");
/* 257 */         LocalSynchronizationManager.this.releaseHeldLocks(this.locks);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.LocalSynchronizationManager
 * JD-Core Version:    0.6.0
 */