/*    */ package org.jboss.aspects.versioned;
/*    */ 
/*    */ import org.jboss.util.LRUCachePolicy;
/*    */ 
/*    */ public class TxCache extends LRUCachePolicy
/*    */ {
/*    */   protected long lockTimeout;
/*    */   protected LocalSynchronizationManager synchManager;
/*    */   protected DistributedVersionManager versionManager;
/*    */ 
/*    */   public TxCache(int maxSize, long lockTimeout)
/*    */   {
/* 36 */     super(2, maxSize);
/* 37 */     this.lockTimeout = lockTimeout;
/* 38 */     this.synchManager = new LocalSynchronizationManager(null);
/* 39 */     this.versionManager = new DistributedVersionManager(lockTimeout, this.synchManager);
/* 40 */     create();
/* 41 */     start();
/*    */   }
/*    */ 
/*    */   public void insert(Object key, Object obj)
/*    */   {
/*    */     try
/*    */     {
/* 48 */       Object versioned = this.versionManager.makeVersioned(obj);
/* 49 */       super.insert(key, versioned);
/*    */     }
/*    */     catch (Exception ex)
/*    */     {
/* 53 */       throw new RuntimeException(ex);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.TxCache
 * JD-Core Version:    0.6.0
 */