/*    */ package org.jboss.aspects.versioned;
/*    */ 
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.HashMap;
/*    */ import org.jboss.aop.Advised;
/*    */ import org.jboss.aop.ClassAdvisor;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.aop.proxy.ClassProxyFactory;
/*    */ import org.jboss.aop.util.reference.MethodPersistentReference;
/*    */ 
/*    */ public class VersionedObjectForwardingInterceptor
/*    */   implements Interceptor
/*    */ {
/*    */   public String getName()
/*    */   {
/* 45 */     return "VersionedObjectForwardingInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable {
/* 49 */     Object target = invocation.getTargetObject();
/* 50 */     if ((target instanceof Advised))
/*    */     {
/* 52 */       ClassAdvisor advisor = (ClassAdvisor)((Advised)target)._getAdvisor();
/*    */ 
/* 55 */       return advisor.invoke(invocation);
/*    */     }
/*    */ 
/* 59 */     if ((invocation instanceof MethodInvocation))
/*    */     {
/* 62 */       MethodInvocation methodInvocation = (MethodInvocation)invocation;
/* 63 */       long methodHash = methodInvocation.getMethodHash();
/* 64 */       HashMap methodMap = ClassProxyFactory.getMethodMap(target.getClass());
/* 65 */       MethodPersistentReference ref = (MethodPersistentReference)methodMap.get(new Long(methodHash));
/* 66 */       Method method = (Method)ref.get();
/* 67 */       Object[] args = methodInvocation.getArguments();
/*    */       try
/*    */       {
/* 70 */         return method.invoke(target, args);
/*    */       }
/*    */       catch (InvocationTargetException ex)
/*    */       {
/* 74 */         throw ex.getTargetException();
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 79 */     throw new RuntimeException("should only be METHOD invocations on a non-advised target object: " + invocation.getClass().getName());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.VersionedObjectForwardingInterceptor
 * JD-Core Version:    0.6.0
 */