/*     */ package org.jboss.beans.info.plugins;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.BeanInfoFactory;
/*     */ import org.jboss.beans.info.spi.EventInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.classadapter.spi.ClassAdapter;
/*     */ import org.jboss.classadapter.spi.DependencyBuilderListItem;
/*     */ import org.jboss.joinpoint.plugins.Config;
/*     */ import org.jboss.joinpoint.spi.ConstructorJoinpoint;
/*     */ import org.jboss.joinpoint.spi.JoinpointFactory;
/*     */ import org.jboss.joinpoint.spi.MethodJoinpoint;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractBeanInfo extends JBossObject
/*     */   implements BeanInfo
/*     */ {
/*     */   protected String name;
/*     */   protected ClassAdapter classAdapter;
/*     */   protected Set<PropertyInfo> properties;
/*  67 */   private transient Map<String, PropertyInfo> propertiesByName = Collections.emptyMap();
/*     */   protected Set<ConstructorInfo> constructors;
/*     */   protected Set<MethodInfo> methods;
/*     */   protected Set<EventInfo> events;
/*     */   protected BeanInfoFactory beanInfoFactory;
/*     */ 
/*     */   public AbstractBeanInfo(BeanInfoFactory beanInfoFactory, ClassAdapter classAdapter, Set<PropertyInfo> properties, Set<ConstructorInfo> constructors, Set<MethodInfo> methods, Set<EventInfo> events)
/*     */   {
/*  94 */     this.beanInfoFactory = beanInfoFactory;
/*  95 */     this.name = classAdapter.getClassInfo().getName();
/*  96 */     this.classAdapter = classAdapter;
/*  97 */     setProperties(properties);
/*  98 */     this.constructors = constructors;
/*  99 */     this.methods = methods;
/* 100 */     this.events = events;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 105 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Set<PropertyInfo> getProperties()
/*     */   {
/* 110 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setProperties(Set<PropertyInfo> properties)
/*     */   {
/* 115 */     this.properties = properties;
/* 116 */     if ((properties != null) && (!properties.isEmpty()))
/*     */     {
/* 118 */       this.propertiesByName = new HashMap(properties.size());
/* 119 */       for (PropertyInfo property : properties)
/*     */       {
/* 121 */         PropertyInfo previous = (PropertyInfo)this.propertiesByName.put(property.getName(), property);
/* 122 */         if (previous != null)
/*     */         {
/*     */           NestedPropertyInfo nestedPropertyInfo;
/*     */           NestedPropertyInfo nestedPropertyInfo;
/* 125 */           if ((previous instanceof NestedPropertyInfo))
/*     */           {
/* 127 */             nestedPropertyInfo = (NestedPropertyInfo)previous;
/*     */           }
/*     */           else
/*     */           {
/* 131 */             nestedPropertyInfo = new NestedPropertyInfo(previous.getName(), this);
/* 132 */             nestedPropertyInfo.addPropertyInfo(previous);
/* 133 */             this.propertiesByName.put(previous.getName(), nestedPropertyInfo);
/*     */           }
/* 135 */           nestedPropertyInfo.addPropertyInfo(property);
/*     */         }
/* 137 */         if ((property instanceof AbstractPropertyInfo))
/*     */         {
/* 139 */           AbstractPropertyInfo ainfo = (AbstractPropertyInfo)property;
/* 140 */           ainfo.beanInfo = this;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public PropertyInfo getProperty(String name)
/*     */   {
/* 155 */     if (name == null) {
/* 156 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 158 */     PropertyInfo property = (PropertyInfo)this.propertiesByName.get(name);
/* 159 */     if (property == null)
/* 160 */       throw new IllegalArgumentException("No such property " + name + " for bean " + getName() + " available " + this.propertiesByName.keySet());
/* 161 */     return property;
/*     */   }
/*     */ 
/*     */   public ClassInfo getClassInfo()
/*     */   {
/* 166 */     return this.classAdapter.getClassInfo();
/*     */   }
/*     */ 
/*     */   public JoinpointFactory getJoinpointFactory()
/*     */   {
/* 171 */     return this.classAdapter.getJoinpointFactory();
/*     */   }
/*     */ 
/*     */   public Set<ConstructorInfo> getConstructors()
/*     */   {
/* 176 */     return this.constructors;
/*     */   }
/*     */ 
/*     */   public void setConstructors(Set<ConstructorInfo> constructors)
/*     */   {
/* 181 */     this.constructors = constructors;
/*     */   }
/*     */ 
/*     */   public Set<EventInfo> getEvents()
/*     */   {
/* 186 */     return this.events;
/*     */   }
/*     */ 
/*     */   public void setEvents(Set<EventInfo> events)
/*     */   {
/* 191 */     this.events = events;
/*     */   }
/*     */ 
/*     */   public Set<MethodInfo> getMethods()
/*     */   {
/* 196 */     return this.methods;
/*     */   }
/*     */ 
/*     */   public void setMethods(Set<MethodInfo> methods)
/*     */   {
/* 201 */     this.methods = methods;
/*     */   }
/*     */ 
/*     */   public BeanInfoFactory getBeanInfoFactory()
/*     */   {
/* 206 */     return this.beanInfoFactory;
/*     */   }
/*     */ 
/*     */   public List<DependencyBuilderListItem> getDependencies(MetaData metaData)
/*     */   {
/* 211 */     return this.classAdapter.getDependencies(metaData);
/*     */   }
/*     */ 
/*     */   public Object newInstance() throws Throwable
/*     */   {
/* 216 */     return newInstance((String[])null, null);
/*     */   }
/*     */ 
/*     */   public Object newInstance(String[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 221 */     ConstructorJoinpoint joinpoint = Config.getConstructorJoinpoint(getJoinpointFactory(), paramTypes, params);
/* 222 */     return joinpoint.dispatch();
/*     */   }
/*     */ 
/*     */   public Object newInstance(Class[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 227 */     return newInstance(classesToStrings(paramTypes), params);
/*     */   }
/*     */ 
/*     */   public Object newInstance(TypeInfo[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 232 */     return newInstance(typeInfosToStrings(paramTypes), params);
/*     */   }
/*     */ 
/*     */   public Object getProperty(Object bean, String name) throws Throwable
/*     */   {
/* 237 */     return BeanInfoUtil.get(this, bean, name);
/*     */   }
/*     */ 
/*     */   public void setProperty(Object bean, String name, Object value) throws Throwable
/*     */   {
/* 242 */     BeanInfoUtil.set(this, bean, name, value);
/*     */   }
/*     */ 
/*     */   public Object invoke(Object bean, String name) throws Throwable
/*     */   {
/* 247 */     return invoke(bean, name, (String[])null, null);
/*     */   }
/*     */ 
/*     */   public Object invoke(Object bean, String name, String[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 252 */     MethodJoinpoint joinpoint = Config.getMethodJoinpoint(bean, getJoinpointFactory(), name, paramTypes, params);
/* 253 */     return joinpoint.dispatch();
/*     */   }
/*     */ 
/*     */   public Object invoke(Object bean, String name, Class[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 258 */     return invoke(bean, name, classesToStrings(paramTypes), params);
/*     */   }
/*     */ 
/*     */   public Object invoke(Object bean, String name, TypeInfo[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 263 */     return invoke(bean, name, typeInfosToStrings(paramTypes), params);
/*     */   }
/*     */ 
/*     */   public Object invokeStatic(String name) throws Throwable
/*     */   {
/* 268 */     return invokeStatic(name, (String[])null, null);
/*     */   }
/*     */ 
/*     */   public Object invokeStatic(String name, String[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 273 */     MethodJoinpoint joinpoint = Config.getStaticMethodJoinpoint(getJoinpointFactory(), name, paramTypes, params);
/* 274 */     return joinpoint.dispatch();
/*     */   }
/*     */ 
/*     */   public Object invokeStatic(String name, Class[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 279 */     return invokeStatic(name, classesToStrings(paramTypes), params);
/*     */   }
/*     */ 
/*     */   public Object invokeStatic(String name, TypeInfo[] paramTypes, Object[] params) throws Throwable
/*     */   {
/* 284 */     return invokeStatic(name, typeInfosToStrings(paramTypes), params);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 289 */     if ((object == null) || (!(object instanceof AbstractBeanInfo))) {
/* 290 */       return false;
/*     */     }
/* 292 */     AbstractBeanInfo other = (AbstractBeanInfo)object;
/* 293 */     if (notEqual(this.name, other.name))
/* 294 */       return false;
/* 295 */     if (notEqual(this.classAdapter, other.classAdapter))
/* 296 */       return false;
/* 297 */     if (notEqual(this.properties, other.properties))
/* 298 */       return false;
/* 299 */     if (notEqual(this.methods, other.methods))
/* 300 */       return false;
/* 301 */     if (notEqual(this.constructors, other.constructors)) {
/* 302 */       return false;
/*     */     }
/* 304 */     return !notEqual(this.events, other.events);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 310 */     buffer.append("name=").append(this.name);
/* 311 */     buffer.append(" classInfo=");
/* 312 */     this.classAdapter.toShortString(buffer);
/* 313 */     buffer.append(" properties=");
/* 314 */     list(buffer, this.properties);
/* 315 */     buffer.append(" methods=");
/* 316 */     list(buffer, this.methods);
/* 317 */     buffer.append(" constructors=");
/* 318 */     list(buffer, this.constructors);
/* 319 */     buffer.append(" events=");
/* 320 */     list(buffer, this.events);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 325 */     buffer.append(this.name);
/*     */   }
/*     */ 
/*     */   public int getHashCode()
/*     */   {
/* 330 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   private static String[] classesToStrings(Class[] classes)
/*     */   {
/* 341 */     if ((classes == null) || (classes.length == 0)) {
/* 342 */       return null;
/*     */     }
/* 344 */     String[] result = new String[classes.length];
/* 345 */     for (int i = 0; i < classes.length; i++)
/*     */     {
/* 347 */       if (classes[i] == null)
/* 348 */         throw new IllegalArgumentException("Null class in parameter types: " + Arrays.asList(classes));
/* 349 */       result[i] = classes[i].getName();
/*     */     }
/* 351 */     return result;
/*     */   }
/*     */ 
/*     */   private static String[] typeInfosToStrings(TypeInfo[] typeInfos)
/*     */   {
/* 362 */     if ((typeInfos == null) || (typeInfos.length == 0)) {
/* 363 */       return null;
/*     */     }
/* 365 */     String[] result = new String[typeInfos.length];
/* 366 */     for (int i = 0; i < typeInfos.length; i++)
/*     */     {
/* 368 */       if (typeInfos[i] == null)
/* 369 */         throw new IllegalArgumentException("Null class in parameter types: " + Arrays.asList(typeInfos));
/* 370 */       result[i] = typeInfos[i].getName();
/*     */     }
/* 372 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.info.plugins.AbstractBeanInfo
 * JD-Core Version:    0.6.0
 */