/*     */ package org.jboss.beans.info.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public class NestedPropertyInfo extends JBossObject
/*     */   implements PropertyInfo, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String name;
/*     */   private BeanInfo beanInfo;
/*  55 */   private List<PropertyInfo> propertys = new ArrayList();
/*     */ 
/*     */   public NestedPropertyInfo(String name, BeanInfo beanInfo)
/*     */   {
/*  59 */     this.name = name;
/*  60 */     this.beanInfo = beanInfo;
/*     */   }
/*     */ 
/*     */   void addPropertyInfo(PropertyInfo propertyInfo)
/*     */   {
/*  65 */     this.propertys.add(propertyInfo);
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo()
/*     */   {
/*  72 */     return this.beanInfo;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  77 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getUpperName()
/*     */   {
/*  82 */     return this.name;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/*  94 */     return null;
/*     */   }
/*     */ 
/*     */   public void set(Object bean, Object value) throws Throwable
/*     */   {
/*  99 */     if (value != null)
/*     */     {
/* 101 */       for (PropertyInfo pi : this.propertys)
/*     */       {
/* 103 */         TypeInfo info = pi.getType();
/* 104 */         if (info != null)
/*     */         {
/* 106 */           TypeInfo valueTypeInfo = info.getTypeInfoFactory().getTypeInfo(value.getClass());
/* 107 */           if (info.isAssignableFrom(valueTypeInfo))
/*     */           {
/* 109 */             pi.set(bean, value);
/* 110 */             return;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 115 */     throw new IllegalArgumentException("Unable to determine setter on " + bean + " for property " + this.name + " with value " + value);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 121 */     if ((object == null) || (!(object instanceof NestedPropertyInfo))) {
/* 122 */       return false;
/*     */     }
/* 124 */     NestedPropertyInfo other = (NestedPropertyInfo)object;
/* 125 */     if (notEqual(this.name, other.name))
/* 126 */       return false;
/* 127 */     if (notEqual(this.beanInfo, other.beanInfo)) {
/* 128 */       return false;
/*     */     }
/* 130 */     return !notEqual(Integer.valueOf(this.propertys.size()), Integer.valueOf(other.propertys.size()));
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 137 */     buffer.append("name=").append(this.name);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 143 */     buffer.append(this.name);
/*     */   }
/*     */ 
/*     */   public int getHashCode()
/*     */   {
/* 149 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public Object get(Object bean)
/*     */     throws Throwable
/*     */   {
/* 156 */     throw new IllegalArgumentException("Unable to determine getter on " + bean + " for property " + this.name);
/*     */   }
/*     */ 
/*     */   public MethodInfo getGetter()
/*     */   {
/* 161 */     throw new IllegalArgumentException("Unable to determine right PropertyInfo on " + this.beanInfo + " by name: " + this.name);
/*     */   }
/*     */ 
/*     */   public void setGetter(MethodInfo getter)
/*     */   {
/* 166 */     throw new NotImplementedException("setGetter");
/*     */   }
/*     */ 
/*     */   public MethodInfo getSetter()
/*     */   {
/* 171 */     throw new IllegalArgumentException("Unable to determine right PropertyInfo on " + this.beanInfo + " by name: " + this.name);
/*     */   }
/*     */ 
/*     */   public void setSetter(MethodInfo setter)
/*     */   {
/* 176 */     throw new NotImplementedException("setSetter");
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 181 */     throw new IllegalArgumentException("Unable to determine right PropertyInfo on " + this.beanInfo + " by name: " + this.name);
/*     */   }
/*     */ 
/*     */   public AnnotationValue getAnnotation(String name)
/*     */   {
/* 186 */     throw new IllegalArgumentException("Unable to determine right PropertyInfo on " + this.beanInfo + " by name: " + this.name);
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(String name)
/*     */   {
/* 191 */     throw new IllegalArgumentException("Unable to determine right PropertyInfo on " + this.beanInfo + " by name: " + this.name);
/*     */   }
/*     */ 
/*     */   public Annotation[] getUnderlyingAnnotations()
/*     */   {
/* 196 */     throw new IllegalArgumentException("Unable to determine right PropertyInfo on " + this.beanInfo + " by name: " + this.name);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getUnderlyingAnnotation(Class<T> annotationType)
/*     */   {
/* 201 */     throw new IllegalArgumentException("Unable to determine right PropertyInfo on " + this.beanInfo + " by name: " + this.name);
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(Class<? extends Annotation> annotationType)
/*     */   {
/* 206 */     throw new IllegalArgumentException("Unable to determine right PropertyInfo on " + this.beanInfo + " by name: " + this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.info.plugins.NestedPropertyInfo
 * JD-Core Version:    0.6.0
 */