/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.annotation.factory.AnnotationCreator;
/*     */ import org.jboss.annotation.factory.ast.TokenMgrError;
/*     */ import org.jboss.beans.metadata.spi.AnnotationMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ 
/*     */ public class AbstractAnnotationMetaData extends JBossObject
/*     */   implements AnnotationMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   public String annotation;
/*     */   protected Annotation ann;
/*  52 */   protected boolean replace = true;
/*     */ 
/*     */   public String getAnnotation()
/*     */   {
/*  64 */     return this.annotation;
/*     */   }
/*     */ 
/*     */   public void setAnnotation(String annotation)
/*     */   {
/*  69 */     this.annotation = annotation;
/*     */   }
/*     */ 
/*     */   public boolean isReplace()
/*     */   {
/*  74 */     return this.replace;
/*     */   }
/*     */ 
/*     */   public void setReplace(boolean replace)
/*     */   {
/*  79 */     this.replace = replace;
/*     */   }
/*     */ 
/*     */   public Annotation getAnnotationInstance()
/*     */   {
/*  84 */     return getAnnotationInstance(null);
/*     */   }
/*     */ 
/*     */   public Annotation getAnnotationInstance(ClassLoader cl)
/*     */   {
/*     */     try
/*     */     {
/*  91 */       String annString = this.annotation;
/*  92 */       if (this.replace)
/*     */       {
/*  94 */         annString = StringPropertyReplacer.replaceProperties(annString);
/*     */       }
/*  96 */       if (cl == null)
/*     */       {
/*  98 */         cl = Thread.currentThread().getContextClassLoader();
/*     */       }
/* 100 */       this.ann = ((Annotation)AnnotationCreator.createAnnotation(annString, cl));
/*     */     }
/*     */     catch (TokenMgrError e)
/*     */     {
/* 104 */       throw new RuntimeException("Error creating annotation for " + this.annotation, e);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 108 */       throw new RuntimeException("Error creating annotation for " + this.annotation, e);
/*     */     }
/*     */ 
/* 111 */     return this.ann;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 116 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/* 121 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 126 */     return null;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 131 */     buffer.append("expr=").append(this.ann);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 136 */     buffer.append(this.ann);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 141 */     return this.annotation.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 146 */     if ((object == null) || (!(object instanceof AbstractAnnotationMetaData))) {
/* 147 */       return false;
/*     */     }
/* 149 */     AbstractAnnotationMetaData amd = (AbstractAnnotationMetaData)object;
/*     */ 
/* 151 */     return (this.replace == amd.replace) && (this.annotation.equals(amd.annotation));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractAnnotationMetaData
 * JD-Core Version:    0.6.0
 */