/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractCollectionMetaData extends AbstractTypeMetaData
/*     */   implements Collection<MetaDataVisitorNode>, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  49 */   protected ArrayList<MetaDataVisitorNode> collection = new ArrayList();
/*     */   protected String elementType;
/*     */ 
/*     */   public String getElementType()
/*     */   {
/*  68 */     return this.elementType;
/*     */   }
/*     */ 
/*     */   public void setElementType(String elementType)
/*     */   {
/*  78 */     this.elementType = elementType;
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/*  84 */     Collection result = (Collection)getTypeInstance(info, cl, Collection.class);
/*     */ 
/*  86 */     TypeInfo elementTypeInfo = getElementClassInfo(cl, info);
/*  87 */     for (int i = 0; i < this.collection.size(); i++)
/*     */     {
/*  89 */       ValueMetaData vmd = (ValueMetaData)this.collection.get(i);
/*  90 */       result.add(vmd.getValue(elementTypeInfo, cl));
/*     */     }
/*  92 */     return result;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable
/*     */   {
/*  97 */     if (this.elementType != null)
/*     */     {
/*  99 */       return getClass(visitor, this.elementType);
/*     */     }
/* 101 */     return super.getType(visitor, previous);
/*     */   }
/*     */ 
/*     */   public boolean add(MetaDataVisitorNode o)
/*     */   {
/* 106 */     return this.collection.add(o);
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection<? extends MetaDataVisitorNode> c)
/*     */   {
/* 111 */     return this.collection.addAll(c);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 116 */     this.collection.clear();
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/* 121 */     return this.collection.contains(o);
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection c)
/*     */   {
/* 126 */     return this.collection.containsAll(c);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 131 */     return this.collection.isEmpty();
/*     */   }
/*     */ 
/*     */   public Iterator<MetaDataVisitorNode> iterator()
/*     */   {
/* 136 */     return this.collection.iterator();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 141 */     return this.collection.remove(o);
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection c)
/*     */   {
/* 146 */     return this.collection.removeAll(c);
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection c)
/*     */   {
/* 151 */     return this.collection.retainAll(c);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 156 */     return this.collection.size();
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 161 */     return this.collection.toArray();
/*     */   }
/*     */ 
/*     */   public <T> T[] toArray(T[] a)
/*     */   {
/* 166 */     return this.collection.toArray(a);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 171 */     return this.collection.iterator();
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 176 */     super.toString(buffer);
/* 177 */     buffer.append(" collection=");
/* 178 */     JBossObject.list(buffer, this.collection);
/*     */   }
/*     */ 
/*     */   protected Object getDefaultInstance()
/*     */   {
/* 188 */     return new ArrayList();
/*     */   }
/*     */ 
/*     */   protected TypeInfo getElementClassInfo(ClassLoader cl, TypeInfo info)
/*     */     throws Throwable
/*     */   {
/* 201 */     if (this.elementType != null) {
/* 202 */       return this.configurator.getClassInfo(this.elementType, cl);
/*     */     }
/*     */ 
/* 205 */     if ((info instanceof ClassInfo))
/*     */     {
/* 207 */       ClassInfo classInfo = (ClassInfo)info;
/* 208 */       return classInfo.getComponentType();
/*     */     }
/*     */ 
/* 211 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractCollectionMetaData
 * JD-Core Version:    0.6.0
 */