/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.beans.metadata.spi.DemandMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.api.dependency.Matcher;
/*     */ import org.jboss.kernel.api.dependency.MatcherFactory;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.util.HashCode;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractDemandMetaData extends JBossObject
/*     */   implements DemandMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected Object demand;
/*  57 */   protected ControllerState whenRequired = ControllerState.DESCRIBED;
/*     */   protected String transformer;
/*     */ 
/*     */   public AbstractDemandMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractDemandMetaData(Object demand)
/*     */   {
/*  76 */     this.demand = demand;
/*     */   }
/*     */ 
/*     */   public void setWhenRequired(ControllerState whenRequired)
/*     */   {
/*  86 */     this.whenRequired = whenRequired;
/*  87 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setDemand(Object demand)
/*     */   {
/*  97 */     this.demand = demand;
/*  98 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Object getDemand()
/*     */   {
/* 103 */     return this.demand;
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequired()
/*     */   {
/* 108 */     return this.whenRequired;
/*     */   }
/*     */ 
/*     */   public String getTransformer()
/*     */   {
/* 118 */     return this.transformer;
/*     */   }
/*     */ 
/*     */   public void setTransformer(String transformer)
/*     */   {
/* 128 */     this.transformer = transformer;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 133 */     KernelControllerContext context = visitor.getControllerContext();
/* 134 */     DependencyItem item = new DemandDependencyItem(context.getName());
/* 135 */     visitor.addDependency(item);
/* 136 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/* 141 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 146 */     return null;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 151 */     buffer.append("demand=").append(this.demand);
/* 152 */     if (this.whenRequired != null)
/* 153 */       buffer.append(" whenRequired=").append(this.whenRequired.getStateString());
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 158 */     buffer.append(this.demand);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 163 */     if (!(obj instanceof AbstractDemandMetaData))
/* 164 */       return false;
/* 165 */     return equals(this.demand, ((AbstractDemandMetaData)obj).demand);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 170 */     return HashCode.generate(this.demand);
/*     */   }
/*     */ 
/*     */   public class DemandDependencyItem extends AbstractDependencyItem
/*     */   {
/*     */     private Matcher matcher;
/*     */ 
/*     */     public DemandDependencyItem(Object name)
/*     */     {
/* 188 */       super(null, AbstractDemandMetaData.this.whenRequired, null);
/* 189 */       if (AbstractDemandMetaData.this.getTransformer() != null)
/* 190 */         this.matcher = MatcherFactory.getInstance().createMatcher(AbstractDemandMetaData.this.getTransformer(), AbstractDemandMetaData.this.getDemand());
/*     */     }
/*     */ 
/*     */     public boolean resolve(Controller controller)
/*     */     {
/* 195 */       Object name = this.matcher != null ? this.matcher : AbstractDemandMetaData.this.getDemand();
/* 196 */       ControllerContext context = controller.getInstalledContext(name);
/* 197 */       if (context != null)
/*     */       {
/* 199 */         setIDependOn(context.getName());
/* 200 */         addDependsOnMe(controller, context);
/* 201 */         setResolved(true);
/*     */       }
/*     */       else
/*     */       {
/* 205 */         setResolved(false);
/*     */       }
/* 207 */       return isResolved();
/*     */     }
/*     */ 
/*     */     public void unresolved()
/*     */     {
/* 212 */       setIDependOn(null);
/* 213 */       setResolved(false);
/*     */     }
/*     */ 
/*     */     public void toString(JBossStringBuilder buffer)
/*     */     {
/* 218 */       super.toString(buffer);
/* 219 */       buffer.append(" demand=").append(AbstractDemandMetaData.this.demand);
/*     */     }
/*     */ 
/*     */     public void toShortString(JBossStringBuilder buffer)
/*     */     {
/* 224 */       buffer.append(getName()).append(" demands ").append(AbstractDemandMetaData.this.demand);
/*     */     }
/*     */ 
/*     */     public String toHumanReadableString()
/*     */     {
/* 230 */       StringBuilder builder = new StringBuilder();
/* 231 */       builder.append("Demands '").append(AbstractDemandMetaData.this.getDemand());
/* 232 */       return builder.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractDemandMetaData
 * JD-Core Version:    0.6.0
 */