/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractDependencyValueMetaData extends AbstractValueMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected transient KernelControllerContext context;
/*     */   protected String property;
/*     */   protected ControllerState whenRequiredState;
/*  63 */   protected ControllerState dependentState = ControllerState.INSTALLED;
/*     */ 
/*     */   public AbstractDependencyValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractDependencyValueMetaData(Object value)
/*     */   {
/*  79 */     super(value);
/*     */   }
/*     */ 
/*     */   public AbstractDependencyValueMetaData(Object value, String property)
/*     */   {
/*  90 */     super(value);
/*  91 */     this.property = property;
/*     */   }
/*     */ 
/*     */   public String getProperty()
/*     */   {
/* 101 */     return this.property;
/*     */   }
/*     */ 
/*     */   public void setProperty(String property)
/*     */   {
/* 111 */     this.property = property;
/*     */   }
/*     */ 
/*     */   public void setWhenRequiredState(ControllerState whenRequiredState)
/*     */   {
/* 121 */     this.whenRequiredState = whenRequiredState;
/* 122 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequiredState()
/*     */   {
/* 127 */     return this.whenRequiredState;
/*     */   }
/*     */ 
/*     */   public void setDependentState(ControllerState dependentState)
/*     */   {
/* 137 */     this.dependentState = dependentState;
/* 138 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ControllerState getDependentState()
/*     */   {
/* 143 */     return this.dependentState;
/*     */   }
/*     */ 
/*     */   protected boolean isLookupValid(ControllerContext lookup)
/*     */   {
/* 148 */     return lookup != null;
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable
/*     */   {
/* 153 */     ControllerState state = this.dependentState;
/* 154 */     if (state == null)
/* 155 */       state = ControllerState.INSTALLED;
/* 156 */     Controller controller = this.context.getController();
/* 157 */     ControllerContext lookup = controller.getContext(getUnderlyingValue(), state);
/*     */ 
/* 159 */     if (!isLookupValid(lookup)) {
/* 160 */       throw new Error("Should not be here - dependency failed - " + this);
/*     */     }
/* 162 */     if (lookup == null) {
/* 163 */       return null;
/*     */     }
/* 165 */     Object result = lookup.getTarget();
/* 166 */     if (this.property != null)
/*     */     {
/* 168 */       if ((lookup instanceof AttributeDispatchContext))
/*     */       {
/* 170 */         AttributeDispatchContext adc = (AttributeDispatchContext)lookup;
/* 171 */         result = adc.get(this.property);
/*     */       }
/*     */       else {
/* 174 */         throw new IllegalArgumentException("Cannot use property attribute, context is not AttributeDispatchContext: " + lookup + ", metadata: " + this);
/*     */       }
/*     */     }
/*     */ 
/* 178 */     return info != null ? info.convertValue(result) : result;
/*     */   }
/*     */ 
/*     */   protected boolean addDependencyItem()
/*     */   {
/* 183 */     return true;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 188 */     this.context = visitor.getControllerContext();
/*     */ 
/* 190 */     if (addDependencyItem())
/*     */     {
/* 192 */       Object name = this.context.getName();
/* 193 */       Object iDependOn = getUnderlyingValue();
/*     */ 
/* 195 */       ControllerState whenRequired = this.whenRequiredState;
/* 196 */       if (whenRequired == null)
/*     */       {
/* 198 */         whenRequired = visitor.getContextState();
/*     */       }
/*     */ 
/* 201 */       DependencyItem item = new AbstractDependencyItem(name, iDependOn, whenRequired, this.dependentState);
/* 202 */       visitor.addDependency(item);
/*     */     }
/* 204 */     super.initialVisit(visitor);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 209 */     super.toString(buffer);
/* 210 */     if (this.property != null)
/* 211 */       buffer.append(" property=").append(this.property);
/* 212 */     if (this.whenRequiredState != null)
/* 213 */       buffer.append(" whenRequiredState=").append(this.whenRequiredState.getStateString());
/* 214 */     if (this.dependentState != null)
/* 215 */       buffer.append(" dependentState=").append(this.dependentState.getStateString());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData
 * JD-Core Version:    0.6.0
 */