/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractPropertyMetaData extends AbstractFeatureMetaData
/*     */   implements PropertyMetaData, ValueMetaDataAware, TypeProvider, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected String name;
/*  54 */   protected boolean preInstantiate = true;
/*     */   protected ValueMetaData value;
/*     */ 
/*     */   public AbstractPropertyMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractPropertyMetaData(String name, Object value)
/*     */   {
/*  74 */     this.name = name;
/*  75 */     this.value = new AbstractValueMetaData(value);
/*     */   }
/*     */ 
/*     */   public AbstractPropertyMetaData(String name, String value)
/*     */   {
/*  86 */     this.name = name;
/*  87 */     this.value = new StringValueMetaData(value);
/*     */   }
/*     */ 
/*     */   public AbstractPropertyMetaData(String name, ValueMetaData value)
/*     */   {
/*  98 */     this.name = name;
/*  99 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public AbstractPropertyMetaData(String name, String value, String type)
/*     */   {
/* 111 */     this.name = name;
/* 112 */     StringValueMetaData svmd = new StringValueMetaData(value);
/* 113 */     svmd.setType(type);
/* 114 */     this.value = svmd;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 119 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 129 */     this.name = name;
/* 130 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 135 */     if ((this.value instanceof AbstractTypeMetaData))
/*     */     {
/* 137 */       return ((AbstractTypeMetaData)this.value).getType();
/*     */     }
/* 139 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isPreInstantiate()
/*     */   {
/* 144 */     return this.preInstantiate;
/*     */   }
/*     */ 
/*     */   public void setPreInstantiate(boolean preInstantiate)
/*     */   {
/* 149 */     this.preInstantiate = preInstantiate;
/*     */   }
/*     */ 
/*     */   public ValueMetaData getValue()
/*     */   {
/* 154 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(ValueMetaData value)
/*     */   {
/* 164 */     this.value = value;
/* 165 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 170 */     visitor.setContextState(ControllerState.CONFIGURED);
/* 171 */     super.initialVisit(visitor);
/*     */   }
/*     */ 
/*     */   public void addChildren(Set<MetaDataVisitorNode> children)
/*     */   {
/* 176 */     if (this.value != null)
/* 177 */       children.add(this.value);
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable
/*     */   {
/* 182 */     String type = getType();
/* 183 */     if (type != null)
/*     */     {
/* 185 */       KernelControllerContext context = visitor.getControllerContext();
/* 186 */       ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
/* 187 */       KernelConfigurator configurator = context.getKernel().getConfigurator();
/* 188 */       return configurator.getClassInfo(type, cl);
/*     */     }
/*     */ 
/* 191 */     KernelControllerContext context = visitor.getControllerContext();
/* 192 */     Set propertyInfos = context.getBeanInfo().getProperties();
/* 193 */     if ((propertyInfos != null) && (!propertyInfos.isEmpty()))
/*     */     {
/* 195 */       for (PropertyInfo pi : propertyInfos)
/*     */       {
/* 197 */         if (getName().equals(pi.getName()))
/*     */         {
/* 199 */           return applyCollectionOrMapCheck(pi.getType());
/*     */         }
/*     */       }
/*     */     }
/* 203 */     throw new IllegalArgumentException("Should not be here - no matching propertyInfo: " + this);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 208 */     buffer.append("name=").append(this.name);
/* 209 */     if (this.value != null)
/* 210 */       buffer.append(" value=").append(this.value);
/* 211 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 216 */     buffer.append(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractPropertyMetaData
 * JD-Core Version:    0.6.0
 */