/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.SupplyMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.HashCode;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class AbstractSupplyMetaData extends JBossObject
/*     */   implements SupplyMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  48 */   private static Logger log = Logger.getLogger(AbstractSupplyMetaData.class);
/*     */   protected Object supply;
/*     */   protected String type;
/*     */ 
/*     */   public AbstractSupplyMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractSupplyMetaData(Object supply)
/*     */   {
/*  82 */     this.supply = supply;
/*     */   }
/*     */ 
/*     */   public void setSupply(Object supply)
/*     */   {
/*  92 */     this.supply = supply;
/*  93 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 103 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/* 113 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public Object getSupply()
/*     */   {
/* 118 */     if (((this.supply instanceof String)) && (this.type != null))
/*     */     {
/* 120 */       PropertyEditor editor = getPropertyEditor();
/* 121 */       editor.setAsText((String)this.supply);
/* 122 */       return editor.getValue();
/*     */     }
/* 124 */     return this.supply;
/*     */   }
/*     */ 
/*     */   protected PropertyEditor getPropertyEditor()
/*     */   {
/*     */     try
/*     */     {
/* 131 */       return PropertyEditors.getEditor(this.type);
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 135 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 141 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/* 146 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 151 */     return null;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 156 */     buffer.append("supply=").append(this.supply);
/* 157 */     if (this.type != null)
/* 158 */       buffer.append(" class=").append(this.type);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 163 */     buffer.append(this.supply);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 168 */     if (!(obj instanceof AbstractSupplyMetaData))
/* 169 */       return false;
/* 170 */     return (equals(this.supply, ((AbstractSupplyMetaData)obj).supply)) && (equals(this.type, ((AbstractSupplyMetaData)obj).type));
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 175 */     return HashCode.generate(this.supply);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  54 */       PropertyEditors.init();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  58 */       log.debug("Unable to initialise property editors", t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractSupplyMetaData
 * JD-Core Version:    0.6.0
 */