/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.helpers.UnmodifiableBeanInfo;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.dependency.spi.helpers.UnmodifiableControllerContext;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.dependency.helpers.UnmodifiableKernelControllerContext;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.reflect.plugins.introspection.ReflectionUtils;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public abstract class FromContext<T extends ControllerContext> extends JBossObject
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  64 */   public static final FromContext NAME = new NameFromContext("name");
/*     */ 
/*  67 */   public static final FromContext ALIASES = new AliasesFromContext("aliases");
/*     */ 
/*  70 */   public static final FromContext METADATA = new MetaDataFromContext("metadata");
/*     */ 
/*  73 */   public static final FromContext BEANINFO = new BeanInfoFromContext("beaninfo");
/*     */ 
/*  76 */   public static final FromContext SCOPE = new ScopeFromContext("scope");
/*     */ 
/*  79 */   public static final FromContext ID = new IdFromContext("id");
/*     */ 
/*  82 */   public static final FromContext CONTEXT = new ThisContext("context");
/*     */   protected final String fromString;
/*     */ 
/*     */   protected FromContext(String fromString)
/*     */   {
/*  94 */     if (fromString == null)
/*  95 */       throw new IllegalArgumentException("Null from string");
/*  96 */     this.fromString = fromString;
/*     */   }
/*     */ 
/*     */   public static FromContext getInstance(String fromString)
/*     */   {
/* 107 */     if (NAME.getFromString().equalsIgnoreCase(fromString))
/* 108 */       return NAME;
/* 109 */     if (ALIASES.getFromString().equalsIgnoreCase(fromString))
/* 110 */       return ALIASES;
/* 111 */     if (METADATA.getFromString().equalsIgnoreCase(fromString))
/* 112 */       return METADATA;
/* 113 */     if (BEANINFO.getFromString().equalsIgnoreCase(fromString))
/* 114 */       return BEANINFO;
/* 115 */     if (SCOPE.getFromString().equalsIgnoreCase(fromString))
/* 116 */       return SCOPE;
/* 117 */     if (ID.getFromString().equalsIgnoreCase(fromString))
/* 118 */       return ID;
/* 119 */     if (CONTEXT.getFromString().equalsIgnoreCase(fromString)) {
/* 120 */       return CONTEXT;
/*     */     }
/* 122 */     return new DynamicFromContext(fromString);
/*     */   }
/*     */ 
/*     */   protected void validate(ControllerContext context)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object executeLookup(ControllerContext context)
/*     */     throws Throwable
/*     */   {
/* 145 */     validate(context);
/* 146 */     return internalExecute(context);
/*     */   }
/*     */ 
/*     */   public abstract Object internalExecute(T paramT)
/*     */     throws Throwable;
/*     */ 
/*     */   public String getFromString()
/*     */   {
/* 165 */     return this.fromString;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 170 */     if ((object == null) || (!(object instanceof FromContext)))
/* 171 */       return false;
/* 172 */     FromContext other = (FromContext)object;
/* 173 */     return this.fromString.equals(other.getFromString());
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 178 */     buffer.append(this.fromString);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 183 */     return this.fromString.hashCode();
/*     */   }
/*     */ 
/*     */   private static class DynamicFromContext extends FromContext
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public DynamicFromContext(String fromString)
/*     */     {
/* 318 */       super();
/*     */     }
/*     */ 
/*     */     protected Method findMethod(Class clazz)
/*     */     {
/* 323 */       if ((clazz == null) || (clazz == Object.class)) {
/* 324 */         return null;
/*     */       }
/* 326 */       Method[] methods = clazz.getDeclaredMethods();
/* 327 */       for (Method m : methods)
/*     */       {
/* 329 */         if ((m.getName().equals(getFromString())) && (m.getParameterTypes().length == 0))
/*     */         {
/* 331 */           return m;
/*     */         }
/*     */       }
/*     */ 
/* 335 */       Method method = findMethod(clazz.getSuperclass());
/* 336 */       if (method != null) {
/* 337 */         return method;
/*     */       }
/* 339 */       for (Class infc : clazz.getInterfaces())
/*     */       {
/* 341 */         Method m = findMethod(infc);
/* 342 */         if (m != null)
/* 343 */           return m;
/*     */       }
/* 345 */       return null;
/*     */     }
/*     */ 
/*     */     protected void getInterfaces(Class clazz, Set<Class> interfaces)
/*     */     {
/* 350 */       if ((clazz == Object.class) || (clazz == null))
/* 351 */         return;
/* 352 */       for (Class iface : clazz.getInterfaces())
/* 353 */         interfaces.add(iface);
/* 354 */       getInterfaces(clazz.getSuperclass(), interfaces);
/*     */     }
/*     */ 
/*     */     public Object internalExecute(ControllerContext context) throws Throwable
/*     */     {
/* 359 */       Method method = findMethod(context.getClass());
/* 360 */       if (method == null)
/* 361 */         throw new IllegalArgumentException("No such getter on context class or mistyped fromContext string: " + getFromString());
/* 362 */       Object result = ReflectionUtils.invoke(method, context, new Object[0]);
/* 363 */       if (result != null)
/*     */       {
/* 365 */         Set interfaces = new HashSet();
/* 366 */         getInterfaces(result.getClass(), interfaces);
/* 367 */         return Proxy.newProxyInstance(ControllerContext.class.getClassLoader(), (Class[])interfaces.toArray(new Class[interfaces.size()]), new DynamicWrapper(result));
/*     */       }
/*     */ 
/* 372 */       return null;
/*     */     }
/*     */ 
/*     */     private class DynamicWrapper
/*     */       implements InvocationHandler
/*     */     {
/*     */       private Object target;
/*     */ 
/*     */       public DynamicWrapper(Object target)
/*     */       {
/* 384 */         this.target = target;
/*     */       }
/*     */ 
/*     */       protected boolean isUnsupported(Method method)
/*     */       {
/* 395 */         String name = method.getName();
/* 396 */         return (name.startsWith("set")) || (name.startsWith("add"));
/*     */       }
/*     */ 
/*     */       public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*     */       {
/* 401 */         if (isUnsupported(method))
/* 402 */           throw new UnsupportedOperationException();
/* 403 */         return ReflectionUtils.invoke(method, this.target, args);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ThisContext extends FromContext
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public ThisContext(String fromString)
/*     */     {
/* 301 */       super();
/*     */     }
/*     */ 
/*     */     public ControllerContext internalExecute(ControllerContext context)
/*     */     {
/* 306 */       if ((context instanceof KernelControllerContext))
/* 307 */         return new UnmodifiableKernelControllerContext((KernelControllerContext)context);
/* 308 */       return new UnmodifiableControllerContext(context);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class IdFromContext extends FromContext
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public IdFromContext(String fromString)
/*     */     {
/* 285 */       super();
/*     */     }
/*     */ 
/*     */     public Object internalExecute(ControllerContext context)
/*     */     {
/* 291 */       return context.getName();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ScopeFromContext extends FromContext.KernelFromContext
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public ScopeFromContext(String fromString)
/*     */     {
/* 270 */       super();
/*     */     }
/*     */ 
/*     */     public ScopeKey internalExecute(KernelControllerContext context)
/*     */     {
/* 275 */       return context.getScopeInfo().getScope();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class BeanInfoFromContext extends FromContext.KernelFromContext
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public BeanInfoFromContext(String fromString)
/*     */     {
/* 254 */       super();
/*     */     }
/*     */ 
/*     */     public BeanInfo internalExecute(KernelControllerContext context)
/*     */     {
/* 259 */       BeanInfo info = context.getBeanInfo();
/* 260 */       return info != null ? new UnmodifiableBeanInfo(info) : null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class MetaDataFromContext extends FromContext.KernelFromContext
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public MetaDataFromContext(String fromString)
/*     */     {
/* 239 */       super();
/*     */     }
/*     */ 
/*     */     public MetaData internalExecute(KernelControllerContext context)
/*     */     {
/* 244 */       return context.getScopeInfo().getMetaData();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class AliasesFromContext extends FromContext
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public AliasesFromContext(String fromString)
/*     */     {
/* 223 */       super();
/*     */     }
/*     */ 
/*     */     public Set<Object> internalExecute(ControllerContext context)
/*     */     {
/* 228 */       Set aliases = context.getAliases();
/* 229 */       return aliases != null ? Collections.unmodifiableSet(aliases) : null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class NameFromContext extends FromContext
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public NameFromContext(String fromString)
/*     */     {
/* 208 */       super();
/*     */     }
/*     */ 
/*     */     public Object internalExecute(ControllerContext context)
/*     */     {
/* 213 */       return context.getName();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract class KernelFromContext extends FromContext<KernelControllerContext>
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     protected KernelFromContext(String fromString)
/*     */     {
/* 192 */       super();
/*     */     }
/*     */ 
/*     */     protected void validate(ControllerContext context)
/*     */     {
/* 197 */       if (!(context instanceof KernelControllerContext))
/* 198 */         throw new UnsupportedOperationException("Cannot execute " + getFromString() + " on underlying context: " + context);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.FromContext
 * JD-Core Version:    0.6.0
 */