/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class StringValueMetaData extends AbstractTypeMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  40 */   private static final Logger log = Logger.getLogger(StringValueMetaData.class);
/*     */ 
/*  46 */   private boolean replace = true;
/*     */ 
/*  52 */   private boolean trim = true;
/*     */ 
/*     */   public StringValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public StringValueMetaData(String value)
/*     */   {
/*  68 */     super(value);
/*     */   }
/*     */ 
/*     */   public void setValue(String value)
/*     */   {
/*  78 */     super.setValue(value);
/*     */   }
/*     */ 
/*     */   public void setValue(Object value)
/*     */   {
/*  83 */     if ((value != null) && (!(value instanceof String)))
/*  84 */       throw new ClassCastException("value is not a String: " + value);
/*  85 */     super.setValue(value);
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable
/*     */   {
/*  90 */     boolean trace = log.isTraceEnabled();
/*  91 */     if (trace) {
/*  92 */       log.trace("getValue value=" + getUnderlyingValue() + " type=" + this.type + " info=" + info);
/*     */     }
/*  94 */     TypeInfo typeInfo = getClassInfo(cl);
/*  95 */     if (typeInfo == null)
/*  96 */       typeInfo = info;
/*  97 */     if (typeInfo == null) {
/*  98 */       throw new IllegalArgumentException("Unable to determine type for value: " + getUnderlyingValue());
/*     */     }
/*     */ 
/* 102 */     if ((typeInfo != info) && (info != null))
/*     */     {
/* 104 */       Object typeValue = typeInfo.convertValue(getUnderlyingValue());
/* 105 */       return info.convertValue(typeValue, this.replace, this.trim);
/*     */     }
/* 107 */     return typeInfo.convertValue(getUnderlyingValue(), this.replace, this.trim);
/*     */   }
/*     */ 
/*     */   protected Object getDefaultInstance()
/*     */   {
/* 112 */     return null;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable
/*     */   {
/* 117 */     if (getType() != null)
/*     */     {
/* 119 */       return getClass(visitor, getType());
/*     */     }
/* 121 */     return super.getType(visitor, previous);
/*     */   }
/*     */ 
/*     */   public boolean isReplace()
/*     */   {
/* 126 */     return this.replace;
/*     */   }
/*     */ 
/*     */   public void setReplace(boolean replace)
/*     */   {
/* 131 */     this.replace = replace;
/*     */   }
/*     */ 
/*     */   public boolean isTrim()
/*     */   {
/* 136 */     return this.trim;
/*     */   }
/*     */ 
/*     */   public void setTrim(boolean trim)
/*     */   {
/* 141 */     this.trim = trim;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.StringValueMetaData
 * JD-Core Version:    0.6.0
 */