/*     */ package org.jboss.beans.metadata.spi;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AutowireType extends JBossObject
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  45 */   public static final AutowireType NONE = new AutowireType("None");
/*     */ 
/*  48 */   public static final AutowireType BY_CLASS = new AutowireType("ByClass");
/*     */ 
/*  51 */   public static final AutowireType BY_NAME = new AutowireType("ByName");
/*     */ 
/*  54 */   public static final AutowireType CONSTRUCTOR = new AutowireType("Constructor");
/*     */ 
/*  57 */   public static final AutowireType AUTO = new AutowireType("Auto");
/*     */ 
/*  60 */   public static final AutowireType[] TYPES = { NONE, BY_CLASS, BY_NAME, CONSTRUCTOR, AUTO };
/*     */   protected final String typeString;
/*     */ 
/*     */   private AutowireType(String typeString)
/*     */   {
/*  78 */     if (typeString == null)
/*  79 */       throw new IllegalArgumentException("Null type string");
/*  80 */     this.typeString = typeString;
/*     */   }
/*     */ 
/*     */   public static AutowireType getInstance(String typeString)
/*     */   {
/*  92 */     for (AutowireType type : TYPES)
/*     */     {
/*  94 */       if (type.getTypeString().equalsIgnoreCase(typeString))
/*  95 */         return type;
/*     */     }
/*  97 */     return NONE;
/*     */   }
/*     */ 
/*     */   public String getTypeString()
/*     */   {
/* 107 */     return this.typeString;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 112 */     if ((object == null) || (!(object instanceof AutowireType)))
/* 113 */       return false;
/* 114 */     AutowireType other = (AutowireType)object;
/* 115 */     return this.typeString.equals(other.getTypeString());
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 120 */     buffer.append(this.typeString);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 125 */     return this.typeString.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.spi.AutowireType
 * JD-Core Version:    0.6.0
 */