/*     */ package org.jboss.bootstrap;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Properties;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.jboss.util.Null;
/*     */ import org.jboss.util.Primitives;
/*     */ import org.jboss.util.platform.Java;
/*     */ 
/*     */ public class BaseServerConfig
/*     */   implements ServerConfig
/*     */ {
/*     */   private Properties props;
/*     */   private URL bootstrapURL;
/*     */   private File homeDir;
/*     */   private URL homeURL;
/*     */   private URL libraryURL;
/*     */   private Object patchURL;
/*     */   private String serverSpecificationVersion;
/*     */   private String serverName;
/*     */   private File serverBaseDir;
/*     */   private File serverHomeDir;
/*     */   private File serverLogDir;
/*     */   private File serverTempDir;
/*     */   private File serverDataDir;
/*     */   private URL serverBaseURL;
/*     */   private URL serverHomeURL;
/*     */   private URL serverLibraryURL;
/*     */   private URL serverConfigURL;
/*     */   private Boolean exitOnShutdown;
/*     */   private Boolean blockingShutdown;
/*     */   private Boolean requireJBossURLStreamHandlerFactory;
/*     */   private Boolean platformMBeanServer;
/*     */   private Boolean installLifeThread;
/*     */   private String rootDeployableFilename;
/*     */ 
/*     */   public BaseServerConfig(Properties props)
/*     */     throws Exception
/*     */   {
/* 106 */     this.props = props;
/*     */ 
/* 109 */     this.homeDir = getFile("jboss.home.dir");
/* 110 */     if (this.homeDir == null)
/* 111 */       throw new Exception("Missing configuration value for: jboss.home.dir");
/* 112 */     System.setProperty("jboss.home.dir", this.homeDir.toString());
/*     */ 
/* 114 */     getServerHomeDir();
/*     */ 
/* 116 */     Package thisPackage = getClass().getPackage();
/* 117 */     this.serverSpecificationVersion = thisPackage.getSpecificationVersion();
/*     */   }
/*     */ 
/*     */   public void initURLs()
/*     */     throws MalformedURLException
/*     */   {
/* 130 */     this.homeURL = getURL("jboss.home.url");
/* 131 */     if (this.homeURL == null)
/* 132 */       this.homeURL = this.homeDir.toURL();
/* 133 */     System.setProperty("jboss.home.url", this.homeURL.toString());
/*     */   }
/*     */ 
/*     */   public URL getBootstrapURL()
/*     */   {
/* 142 */     if (this.bootstrapURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 146 */         this.bootstrapURL = getURL("jboss.bootstrap.url");
/* 147 */         if (this.bootstrapURL != null)
/* 148 */           System.setProperty("jboss.bootstrap.url", "jboss.bootstrap.url".toString());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 152 */         throw new NestedRuntimeException(e);
/*     */       }
/*     */     }
/*     */ 
/* 156 */     return this.bootstrapURL;
/*     */   }
/*     */ 
/*     */   public File getHomeDir()
/*     */   {
/* 161 */     return this.homeDir;
/*     */   }
/*     */ 
/*     */   public URL getHomeURL()
/*     */   {
/* 166 */     return this.homeURL;
/*     */   }
/*     */ 
/*     */   public URL getLibraryURL()
/*     */   {
/* 171 */     if (this.libraryURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 175 */         this.libraryURL = getURL("jboss.lib.url");
/* 176 */         if (this.libraryURL == null)
/*     */         {
/* 178 */           this.libraryURL = new URL(this.homeURL, "lib/");
/*     */         }
/* 180 */         System.setProperty("jboss.lib.url", this.libraryURL.toString());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 184 */         throw new NestedRuntimeException(e);
/*     */       }
/*     */     }
/* 187 */     return this.libraryURL;
/*     */   }
/*     */ 
/*     */   public URL getPatchURL()
/*     */   {
/* 192 */     if (this.patchURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 196 */         this.patchURL = getURL("jboss.patch.url");
/* 197 */         if (this.patchURL == null)
/*     */         {
/* 199 */           this.patchURL = Null.VALUE;
/*     */         }
/*     */         else
/*     */         {
/* 203 */           System.setProperty("jboss.patch.url", this.patchURL.toString());
/*     */         }
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 208 */         throw new NestedRuntimeException(e);
/*     */       }
/*     */     }
/*     */ 
/* 212 */     if (this.patchURL == Null.VALUE) {
/* 213 */       return null;
/*     */     }
/* 215 */     return (URL)this.patchURL;
/*     */   }
/*     */ 
/*     */   public String getServerName()
/*     */   {
/* 220 */     if (this.serverName == null)
/*     */     {
/* 222 */       this.serverName = this.props.getProperty("jboss.server.name", "default");
/* 223 */       System.setProperty("jboss.server.name", this.serverName);
/*     */     }
/* 225 */     return this.serverName;
/*     */   }
/*     */ 
/*     */   public File getServerBaseDir()
/*     */   {
/* 230 */     if (this.serverBaseDir == null)
/*     */     {
/* 232 */       this.serverBaseDir = getFile("jboss.server.base.dir");
/* 233 */       if (this.serverBaseDir == null)
/*     */       {
/* 235 */         this.serverBaseDir = new File(this.homeDir, "server");
/* 236 */         System.setProperty("jboss.server.base.dir", this.serverBaseDir.toString());
/*     */       }
/*     */     }
/* 239 */     return this.serverBaseDir;
/*     */   }
/*     */ 
/*     */   public File getServerHomeDir()
/*     */   {
/* 244 */     if (this.serverHomeDir == null)
/*     */     {
/* 246 */       this.serverHomeDir = getFile("jboss.server.home.dir");
/* 247 */       if (this.serverHomeDir == null)
/*     */       {
/* 249 */         this.serverHomeDir = new File(getServerBaseDir(), getServerName());
/* 250 */         System.setProperty("jboss.server.home.dir", this.serverHomeDir.toString());
/*     */       }
/*     */     }
/* 253 */     return this.serverHomeDir;
/*     */   }
/*     */ 
/*     */   public File getServerLogDir()
/*     */   {
/* 266 */     if (this.serverLogDir == null)
/*     */     {
/* 268 */       this.serverLogDir = getFile("jboss.server.log.dir");
/* 269 */       if (this.serverLogDir == null)
/*     */       {
/* 271 */         this.serverLogDir = new File(getServerHomeDir(), "log");
/* 272 */         System.setProperty("jboss.server.log.dir", this.serverLogDir.toString());
/*     */       }
/*     */     }
/* 275 */     return this.serverLogDir;
/*     */   }
/*     */ 
/*     */   public File getServerTempDir()
/*     */   {
/* 285 */     if (this.serverTempDir == null)
/*     */     {
/* 287 */       this.serverTempDir = getFile("jboss.server.temp.dir");
/* 288 */       if (this.serverTempDir == null)
/*     */       {
/* 290 */         this.serverTempDir = new File(getServerHomeDir(), "tmp");
/* 291 */         System.setProperty("jboss.server.temp.dir", this.serverTempDir.toString());
/*     */       }
/*     */     }
/* 294 */     return this.serverTempDir;
/*     */   }
/*     */ 
/*     */   public File getServerDataDir()
/*     */   {
/* 304 */     if (this.serverDataDir == null)
/*     */     {
/* 306 */       this.serverDataDir = getFile("jboss.server.data.dir");
/* 307 */       if (this.serverDataDir == null)
/*     */       {
/* 309 */         this.serverDataDir = new File(getServerHomeDir(), "data");
/* 310 */         System.setProperty("jboss.server.data.dir", this.serverDataDir.toString());
/*     */       }
/*     */     }
/* 313 */     return this.serverDataDir;
/*     */   }
/*     */ 
/*     */   public File getServerNativeDir()
/*     */   {
/* 323 */     String fileName = System.getProperty("jboss.native.dir");
/* 324 */     if (fileName != null)
/* 325 */       return new File(fileName);
/* 326 */     return new File(getServerTempDir(), "native");
/*     */   }
/*     */ 
/*     */   public File getServerTempDeployDir()
/*     */   {
/* 336 */     return new File(getServerTempDir(), "deploy");
/*     */   }
/*     */ 
/*     */   public URL getServerBaseURL()
/*     */   {
/* 341 */     if (this.serverBaseURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 345 */         this.serverBaseURL = getURL("jboss.server.base.url");
/* 346 */         if (this.serverBaseURL == null)
/*     */         {
/* 348 */           this.serverBaseURL = new URL(this.homeURL, "server/");
/*     */         }
/* 350 */         System.setProperty("jboss.server.base.url", this.serverBaseURL.toString());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 354 */         throw new NestedRuntimeException(e);
/*     */       }
/*     */     }
/* 357 */     return this.serverBaseURL;
/*     */   }
/*     */ 
/*     */   public URL getServerHomeURL()
/*     */   {
/* 362 */     if (this.serverHomeURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 366 */         this.serverHomeURL = getURL("jboss.server.home.url");
/* 367 */         if (this.serverHomeURL == null)
/*     */         {
/* 369 */           this.serverHomeURL = new URL(getServerBaseURL(), getServerName() + "/");
/*     */         }
/* 371 */         System.setProperty("jboss.server.home.url", this.serverHomeURL.toString());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 375 */         throw new NestedRuntimeException(e);
/*     */       }
/*     */     }
/* 378 */     return this.serverHomeURL;
/*     */   }
/*     */ 
/*     */   public URL getServerLibraryURL()
/*     */   {
/* 383 */     if (this.serverLibraryURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 387 */         this.serverLibraryURL = getURL("jboss.server.lib.url");
/* 388 */         if (this.serverLibraryURL == null)
/*     */         {
/* 390 */           this.serverLibraryURL = new URL(getServerHomeURL(), "lib/");
/*     */         }
/* 392 */         System.setProperty("jboss.server.lib.url", this.serverLibraryURL.toString());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 396 */         throw new NestedRuntimeException(e);
/*     */       }
/*     */     }
/* 399 */     return this.serverLibraryURL;
/*     */   }
/*     */ 
/*     */   public URL getServerConfigURL()
/*     */   {
/* 404 */     if (this.serverConfigURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 408 */         this.serverConfigURL = getURL("jboss.server.config.url");
/* 409 */         if (this.serverConfigURL == null)
/*     */         {
/* 411 */           this.serverConfigURL = new URL(getServerHomeURL(), "conf/");
/*     */         }
/* 413 */         System.setProperty("jboss.server.config.url", this.serverConfigURL.toString());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 417 */         throw new NestedRuntimeException(e);
/*     */       }
/*     */     }
/* 420 */     return this.serverConfigURL;
/*     */   }
/*     */ 
/*     */   public boolean getPlatformMBeanServer()
/*     */   {
/* 433 */     if (this.platformMBeanServer == null)
/*     */     {
/* 435 */       if (Java.isCompatible(6))
/*     */       {
/* 438 */         String value = this.props.getProperty("jboss.platform.mbeanserver", new Boolean(false).toString());
/*     */ 
/* 442 */         value = "".equals(value) ? "true" : value;
/*     */ 
/* 445 */         this.platformMBeanServer = new Boolean(value);
/*     */       }
/*     */       else
/*     */       {
/* 450 */         this.platformMBeanServer = Boolean.FALSE;
/*     */       }
/*     */     }
/* 453 */     return this.platformMBeanServer.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setExitOnShutdown(boolean flag)
/*     */   {
/* 465 */     this.exitOnShutdown = Primitives.valueOf(flag);
/*     */   }
/*     */ 
/*     */   public boolean getExitOnShutdown()
/*     */   {
/* 475 */     if (this.exitOnShutdown == null)
/*     */     {
/* 477 */       String value = this.props.getProperty("jboss.server.exitonshutdown", null);
/* 478 */       if (value == null)
/*     */       {
/* 480 */         this.exitOnShutdown = Primitives.valueOf(true);
/*     */       }
/*     */       else
/*     */       {
/* 484 */         this.exitOnShutdown = new Boolean(value);
/*     */       }
/*     */     }
/* 487 */     return this.exitOnShutdown.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setInstallLifeThread(boolean flag)
/*     */   {
/* 492 */     this.installLifeThread = Primitives.valueOf(flag);
/*     */   }
/*     */ 
/*     */   public boolean isInstallLifeThread()
/*     */   {
/* 497 */     if (this.installLifeThread == null)
/*     */     {
/* 499 */       String value = this.props.getProperty("jboss.server.lifethread", null);
/* 500 */       if (value == null)
/*     */       {
/* 502 */         this.installLifeThread = Primitives.valueOf(true);
/*     */       }
/*     */       else
/*     */       {
/* 506 */         this.installLifeThread = new Boolean(value);
/*     */       }
/*     */     }
/* 509 */     return this.installLifeThread.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setBlockingShutdown(boolean flag)
/*     */   {
/* 522 */     this.blockingShutdown = Primitives.valueOf(flag);
/*     */   }
/*     */ 
/*     */   public boolean getBlockingShutdown()
/*     */   {
/* 532 */     if (this.blockingShutdown == null)
/*     */     {
/* 534 */       String value = this.props.getProperty("jboss.server.blockingshutdown", null);
/* 535 */       if (value == null)
/*     */       {
/* 537 */         this.blockingShutdown = Primitives.valueOf(false);
/*     */       }
/*     */       else
/*     */       {
/* 541 */         this.blockingShutdown = new Boolean(value);
/*     */       }
/*     */     }
/* 544 */     return this.blockingShutdown.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setRequireJBossURLStreamHandlerFactory(boolean flag)
/*     */   {
/* 557 */     this.requireJBossURLStreamHandlerFactory = Primitives.valueOf(flag);
/*     */   }
/*     */ 
/*     */   public boolean getRequireJBossURLStreamHandlerFactory()
/*     */   {
/* 567 */     if (this.requireJBossURLStreamHandlerFactory == null)
/*     */     {
/* 569 */       String value = this.props.getProperty("jboss.server.requirejbossurlstreamhandlerfactory", null);
/* 570 */       if (value == null)
/*     */       {
/* 572 */         this.requireJBossURLStreamHandlerFactory = Primitives.valueOf(true);
/*     */       }
/*     */       else
/*     */       {
/* 576 */         this.requireJBossURLStreamHandlerFactory = new Boolean(value);
/*     */       }
/*     */     }
/* 579 */     return this.requireJBossURLStreamHandlerFactory.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setRootDeploymentFilename(String filename)
/*     */   {
/* 590 */     this.rootDeployableFilename = filename;
/*     */   }
/*     */ 
/*     */   public String getRootDeploymentFilename()
/*     */   {
/* 601 */     if (this.rootDeployableFilename == null)
/*     */     {
/* 603 */       this.rootDeployableFilename = this.props.getProperty("jboss.server.root.deployment.filename", "jboss-service.xml");
/*     */     }
/*     */ 
/* 607 */     return this.rootDeployableFilename;
/*     */   }
/*     */ 
/*     */   private URL getURL(String name)
/*     */     throws MalformedURLException
/*     */   {
/* 615 */     String value = this.props.getProperty(name, null);
/* 616 */     if (value != null)
/*     */     {
/* 618 */       if (!value.endsWith("/")) value = value + "/";
/* 619 */       return new URL(value);
/*     */     }
/*     */ 
/* 622 */     return null;
/*     */   }
/*     */ 
/*     */   private File getFile(String name)
/*     */   {
/* 631 */     String value = this.props.getProperty(name, null);
/* 632 */     if (value != null)
/*     */     {
/*     */       try
/*     */       {
/* 636 */         File f = new File(value);
/* 637 */         return f.getCanonicalFile();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 641 */         return new File(value);
/*     */       }
/*     */     }
/*     */ 
/* 645 */     return null;
/*     */   }
/*     */ 
/*     */   public String getSpecificationVersion()
/*     */   {
/* 650 */     return this.serverSpecificationVersion;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.bootstrap.BaseServerConfig
 * JD-Core Version:    0.6.0
 */