/*     */ package org.jboss.cache.invalidation;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Vector;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanConstructorInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class InvalidationManager extends ServiceMBeanSupport
/*     */   implements InvalidationManagerMBean
/*     */ {
/*     */   public static final String DEFAULT_JMX_SERVICE_NAME = "jboss.cache:service=InvalidationManager";
/*     */   public static final String DEFAULT_INVALIDERS_JMX_NAME = "jboss.cache:service=InvalidationGroup";
/*  52 */   protected Hashtable groups = new Hashtable();
/*  53 */   protected Vector bridgeSubscribers = new Vector();
/*  54 */   protected int hashcode = 0;
/*     */ 
/*  56 */   protected boolean DEFAULT_TO_ASYNCHRONOUS_MODE = false;
/*     */ 
/*     */   public void startService()
/*     */     throws Exception
/*     */   {
/*  68 */     this.log.debug("Starting Invalidation Manager " + getServiceName().toString());
/*  69 */     Registry.bind(getServiceName().toString(), this);
/*  70 */     this.hashcode = getServiceName().hashCode();
/*     */   }
/*     */ 
/*     */   public void stopService()
/*     */   {
/*  75 */     this.log.debug("Stoping Invalidation Manager " + getServiceName().toString());
/*  76 */     Registry.unbind(getServiceName().toString());
/*     */   }
/*     */ 
/*     */   public boolean getIsAsynchByDefault()
/*     */   {
/*  81 */     return this.DEFAULT_TO_ASYNCHRONOUS_MODE;
/*     */   }
/*     */ 
/*     */   public void setIsAsynchByDefault(boolean flag) {
/*  85 */     this.DEFAULT_TO_ASYNCHRONOUS_MODE = flag;
/*     */   }
/*     */ 
/*     */   public Collection getInvalidationGroups()
/*     */   {
/*  90 */     return this.groups.values();
/*     */   }
/*     */ 
/*     */   public InvalidationGroup getInvalidationGroup(String groupName)
/*     */   {
/*  95 */     synchronized (this.groups)
/*     */     {
/*  97 */       InvalidationGroup group = (InvalidationGroup)this.groups.get(groupName);
/*  98 */       if (group == null)
/*     */       {
/* 100 */         group = createGroup(groupName);
/*     */       }
/*     */ 
/* 103 */       group.addReference();
/*     */ 
/* 105 */       return group;
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized BridgeInvalidationSubscription registerBridgeListener(InvalidationBridgeListener listener)
/*     */   {
/* 111 */     this.log.debug("Subscribing a new cache-invalidation bridge");
/* 112 */     BridgeInvalidationSubscription subs = new BridgeInvalidationSubscriptionImpl(listener);
/*     */ 
/* 114 */     Vector newVector = new Vector(this.bridgeSubscribers);
/* 115 */     newVector.add(subs);
/* 116 */     this.bridgeSubscribers = newVector;
/*     */ 
/* 118 */     return subs;
/*     */   }
/*     */ 
/*     */   public void batchInvalidate(BatchInvalidation[] invalidations)
/*     */   {
/* 123 */     batchInvalidate(invalidations, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */   }
/*     */ 
/*     */   public void batchInvalidate(BatchInvalidation[] invalidations, boolean asynchronous)
/*     */   {
/* 128 */     if (this.log.isTraceEnabled()) {
/* 129 */       this.log.trace("Batch cache invalidation. Caches concerned: " + invalidations.length);
/*     */     }
/* 131 */     crossDomainBatchInvalidate(null, invalidations, asynchronous);
/*     */   }
/*     */ 
/*     */   public void invalidateAll(String groupName)
/*     */   {
/* 136 */     invalidateAll(groupName, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */   }
/*     */ 
/*     */   public void invalidateAll(String groupName, boolean async)
/*     */   {
/* 141 */     if (this.log.isTraceEnabled()) {
/* 142 */       this.log.trace("Invalidate all for group: " + groupName);
/*     */     }
/* 144 */     crossDomainInvalidateAll(null, groupName, async);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 155 */     return this.hashcode;
/*     */   }
/*     */ 
/*     */   protected InvalidationGroup createGroup(String groupName)
/*     */   {
/* 163 */     InvalidationGroup group = new InvalidationGroupImpl(groupName);
/* 164 */     this.groups.put(groupName, group);
/*     */     try
/*     */     {
/* 171 */       this.log.debug("Creating and registering a new InvalidationGroup: " + groupName);
/* 172 */       ObjectName groupObjectName = new ObjectName("jboss.cache:service=InvalidationGroup,GroupName=" + groupName);
/* 173 */       getServer().registerMBean(group, groupObjectName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 177 */       this.log.debug("Problem while trying to register a new invalidation group in JMX", e);
/*     */     }
/*     */ 
/* 182 */     this.log.debug("Informing bridges about new group creation ...");
/* 183 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++) {
/* 184 */       ((BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).groupCreated(groupName);
/*     */     }
/* 186 */     return group;
/*     */   }
/*     */ 
/*     */   protected void removeGroup(String groupName)
/*     */   {
/* 191 */     synchronized (this.groups)
/*     */     {
/* 193 */       this.groups.remove(groupName);
/*     */       try
/*     */       {
/* 199 */         this.log.debug("Removing and JMX-unregistering an InvalidationGroup: " + groupName);
/* 200 */         ObjectName groupObjectName = new ObjectName("jboss.cache:service=InvalidationGroup,GroupName=" + groupName);
/* 201 */         getServer().unregisterMBean(groupObjectName);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 205 */         this.log.debug("Problem while trying to un-register a new invalidation group in JMX", e);
/*     */       }
/*     */ 
/* 210 */       for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/* 211 */         ((BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).groupDropped(groupName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized void unregisterBridgeListener(BridgeInvalidationSubscription bridgeSubscriber)
/*     */   {
/* 220 */     this.log.debug("Unsubscription of a cache-invalidation bridge");
/*     */ 
/* 222 */     Vector newVector = new Vector(this.bridgeSubscribers);
/* 223 */     newVector.remove(bridgeSubscriber);
/* 224 */     this.bridgeSubscribers = newVector;
/*     */   }
/*     */ 
/*     */   protected void doLocalOnlyInvalidation(String groupName, Serializable key, boolean asynchronous)
/*     */   {
/* 229 */     InvalidationGroupImpl group = (InvalidationGroupImpl)this.groups.get(groupName);
/* 230 */     if (group != null)
/* 231 */       group.localOnlyInvalidate(key, asynchronous);
/*     */   }
/*     */ 
/*     */   protected void doLocalOnlyInvalidations(String groupName, Serializable[] keys, boolean asynchronous)
/*     */   {
/* 236 */     InvalidationGroupImpl group = (InvalidationGroupImpl)this.groups.get(groupName);
/* 237 */     if (group != null)
/* 238 */       group.localOnlyInvalidate(keys, asynchronous);
/*     */   }
/*     */ 
/*     */   protected void doLocalOnlyInvalidateAll(String groupName, boolean asynchronous)
/*     */   {
/* 243 */     InvalidationGroupImpl group = (InvalidationGroupImpl)this.groups.get(groupName);
/* 244 */     if (group != null)
/* 245 */       group.localOnlyInvalidateAll();
/*     */   }
/*     */ 
/*     */   protected void doBridgedOnlyInvalidation(BridgeInvalidationSubscriptionImpl exceptSource, String groupName, Serializable key)
/*     */   {
/* 250 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/*     */     {
/* 252 */       BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
/* 253 */       if (bridge != exceptSource)
/* 254 */         bridge.bridgedInvalidate(groupName, key, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void doBridgedOnlyInvalidation(BridgeInvalidationSubscriptionImpl exceptSource, String groupName, Serializable[] keys)
/*     */   {
/* 260 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/*     */     {
/* 262 */       BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
/* 263 */       if (bridge != exceptSource)
/* 264 */         bridge.bridgedInvalidate(groupName, keys, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void doBridgedOnlyInvalidateAll(BridgeInvalidationSubscriptionImpl exceptSource, String groupName)
/*     */   {
/* 270 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/*     */     {
/* 272 */       BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
/* 273 */       if (bridge != exceptSource)
/* 274 */         bridge.bridgedInvalidateAll(groupName, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void localGroupInvalidationEvent(String groupName, Serializable key, boolean asynchronous)
/*     */   {
/* 284 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/* 285 */       ((BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).bridgedInvalidate(groupName, key, asynchronous);
/*     */   }
/*     */ 
/*     */   protected void localGroupInvalidationsEvent(String groupName, Serializable[] keys, boolean asynchronous)
/*     */   {
/* 290 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/* 291 */       ((BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).bridgedInvalidate(groupName, keys, asynchronous);
/*     */   }
/*     */ 
/*     */   protected void localGroupInvalidateAllEvent(String groupName, boolean asynchronous)
/*     */   {
/* 296 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/* 297 */       ((BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).bridgedInvalidateAll(groupName, asynchronous);
/*     */   }
/*     */ 
/*     */   protected void bridgeGroupInvalidationEvent(BridgeInvalidationSubscriptionImpl source, String groupName, Serializable key)
/*     */   {
/* 304 */     doBridgedOnlyInvalidation(source, groupName, key);
/* 305 */     doLocalOnlyInvalidation(groupName, key, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */   }
/*     */ 
/*     */   protected void bridgeGroupInvalidationEvent(BridgeInvalidationSubscriptionImpl source, String groupName, Serializable[] keys)
/*     */   {
/* 310 */     doBridgedOnlyInvalidation(source, groupName, keys);
/* 311 */     doLocalOnlyInvalidation(groupName, keys, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */   }
/*     */ 
/*     */   protected void bridgeGroupInvalidateAllEvent(BridgeInvalidationSubscriptionImpl source, String groupName)
/*     */   {
/* 316 */     doBridgedOnlyInvalidateAll(source, groupName);
/* 317 */     doLocalOnlyInvalidateAll(groupName, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */   }
/*     */ 
/*     */   protected void crossDomainBatchInvalidate(BridgeInvalidationSubscriptionImpl source, BatchInvalidation[] invalidations, boolean asynchronous)
/*     */   {
/* 322 */     if (invalidations == null) {
/* 323 */       return;
/*     */     }
/*     */ 
/* 327 */     for (int i = 0; i < invalidations.length; i++)
/*     */     {
/* 329 */       BatchInvalidation currInvalid = invalidations[i];
/*     */ 
/* 331 */       doLocalOnlyInvalidations(currInvalid.getInvalidationGroupName(), currInvalid.getIds(), asynchronous);
/*     */     }
/*     */ 
/* 338 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/*     */     {
/* 340 */       BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
/* 341 */       if (bridge != source)
/* 342 */         bridge.bridgedBatchInvalidations(invalidations, asynchronous);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void crossDomainInvalidateAll(BridgeInvalidationSubscriptionImpl source, String groupName, boolean asynchronous)
/*     */   {
/* 350 */     doLocalOnlyInvalidateAll(groupName, asynchronous);
/*     */ 
/* 354 */     for (int i = 0; i < this.bridgeSubscribers.size(); i++)
/*     */     {
/* 356 */       BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)(BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
/* 357 */       if (bridge != source)
/* 358 */         bridge.bridgedInvalidateAll(groupName, asynchronous);
/*     */     }
/*     */   }
/*     */ 
/*     */   class BridgeInvalidationSubscriptionImpl
/*     */     implements BridgeInvalidationSubscription
/*     */   {
/* 704 */     protected InvalidationBridgeListener listener = null;
/*     */ 
/*     */     public BridgeInvalidationSubscriptionImpl(InvalidationBridgeListener listener)
/*     */     {
/* 708 */       this.listener = listener;
/*     */     }
/*     */ 
/*     */     public void invalidate(String invalidationGroupName, Serializable key)
/*     */     {
/* 713 */       InvalidationManager.this.bridgeGroupInvalidationEvent(this, invalidationGroupName, key);
/*     */     }
/*     */ 
/*     */     public void invalidate(String invalidationGroupName, Serializable[] keys)
/*     */     {
/* 718 */       InvalidationManager.this.bridgeGroupInvalidationEvent(this, invalidationGroupName, keys);
/*     */     }
/*     */ 
/*     */     public void invalidateAll(String groupName)
/*     */     {
/* 723 */       InvalidationManager.this.bridgeGroupInvalidateAllEvent(this, groupName);
/*     */     }
/*     */ 
/*     */     public void batchInvalidate(BatchInvalidation[] invalidations)
/*     */     {
/* 728 */       InvalidationManager.this.crossDomainBatchInvalidate(this, invalidations, InvalidationManager.this.DEFAULT_TO_ASYNCHRONOUS_MODE);
/*     */     }
/*     */ 
/*     */     public void unregister()
/*     */     {
/* 734 */       InvalidationManager.this.unregisterBridgeListener(this);
/*     */     }
/*     */ 
/*     */     protected void bridgedInvalidate(String invalidationGroupName, Serializable key, boolean asynchronous)
/*     */     {
/* 742 */       this.listener.invalidate(invalidationGroupName, key, asynchronous);
/*     */     }
/*     */ 
/*     */     protected void bridgedInvalidate(String invalidationGroupName, Serializable[] keys, boolean asynchronous)
/*     */     {
/* 747 */       this.listener.invalidate(invalidationGroupName, keys, asynchronous);
/*     */     }
/*     */ 
/*     */     protected void bridgedInvalidateAll(String invalidationGroupName, boolean asynchronous)
/*     */     {
/* 752 */       this.listener.invalidateAll(invalidationGroupName, asynchronous);
/*     */     }
/*     */ 
/*     */     protected void bridgedBatchInvalidations(BatchInvalidation[] invalidations, boolean asynchronous)
/*     */     {
/* 757 */       this.listener.batchInvalidate(invalidations, asynchronous);
/*     */     }
/*     */ 
/*     */     protected void groupCreated(String invalidationGroupName)
/*     */     {
/* 762 */       this.listener.newGroupCreated(invalidationGroupName);
/*     */     }
/*     */ 
/*     */     protected void groupDropped(String invalidationGroupName)
/*     */     {
/* 767 */       this.listener.groupIsDropped(invalidationGroupName);
/*     */     }
/*     */   }
/*     */ 
/*     */   class InvalidationGroupImpl
/*     */     implements InvalidationGroup, DynamicMBean
/*     */   {
/* 372 */     protected Logger igLog = null;
/* 373 */     protected String groupName = null;
/* 374 */     protected boolean asynchronous = InvalidationManager.this.DEFAULT_TO_ASYNCHRONOUS_MODE;
/* 375 */     protected HashSet registered = new HashSet();
/* 376 */     protected int counter = 0;
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 380 */       return this.groupName.hashCode();
/*     */     }
/*     */ 
/*     */     public String getGroupName()
/*     */     {
/* 385 */       return this.groupName;
/*     */     }
/*     */ 
/*     */     public InvalidationGroupImpl(String groupName)
/*     */     {
/* 390 */       this.groupName = groupName;
/*     */ 
/* 392 */       String escapedClass = getClass().getName().replace('$', '.');
/* 393 */       this.igLog = Logger.getLogger(escapedClass + "." + groupName);
/*     */     }
/*     */ 
/*     */     public InvalidationManagerMBean getInvalidationManager()
/*     */     {
/* 398 */       return InvalidationManager.this;
/*     */     }
/*     */ 
/*     */     public void invalidate(Serializable key)
/*     */     {
/* 403 */       invalidate(key, this.asynchronous);
/*     */     }
/*     */ 
/*     */     public void invalidate(Serializable key, boolean asynchronous)
/*     */     {
/* 408 */       localOnlyInvalidate(key, asynchronous);
/*     */ 
/* 410 */       InvalidationManager.this.localGroupInvalidationEvent(this.groupName, key, asynchronous);
/*     */     }
/*     */ 
/*     */     public void invalidate(Serializable[] keys)
/*     */     {
/* 415 */       invalidate(keys, this.asynchronous);
/*     */     }
/*     */ 
/*     */     public void invalidate(Serializable[] keys, boolean asynchronous)
/*     */     {
/* 420 */       localOnlyInvalidate(keys, asynchronous);
/*     */ 
/* 422 */       InvalidationManager.this.localGroupInvalidationsEvent(this.groupName, keys, asynchronous);
/*     */     }
/*     */ 
/*     */     public void invalidateAll()
/*     */     {
/* 427 */       invalidateAll(this.asynchronous);
/*     */     }
/*     */ 
/*     */     public void invalidateAll(boolean asynchronous)
/*     */     {
/* 432 */       localOnlyInvalidateAll();
/* 433 */       InvalidationManager.this.localGroupInvalidateAllEvent(this.groupName, asynchronous);
/*     */     }
/*     */ 
/*     */     public synchronized void register(Invalidatable newRegistered)
/*     */     {
/* 440 */       HashSet newlyRegistered = new HashSet(this.registered);
/* 441 */       newlyRegistered.add(newRegistered);
/*     */ 
/* 443 */       this.registered = newlyRegistered;
/*     */     }
/*     */ 
/*     */     public synchronized void unregister(Invalidatable oldRegistered)
/*     */     {
/* 450 */       HashSet newlyRegistered = new HashSet(this.registered);
/* 451 */       newlyRegistered.remove(oldRegistered);
/*     */ 
/* 453 */       this.registered = newlyRegistered;
/*     */ 
/* 455 */       removeReference();
/*     */     }
/*     */ 
/*     */     public void setAsynchronousInvalidation(boolean async)
/*     */     {
/* 460 */       this.asynchronous = async;
/*     */     }
/*     */ 
/*     */     public boolean getAsynchronousInvalidation()
/*     */     {
/* 465 */       return this.asynchronous;
/*     */     }
/*     */ 
/*     */     public void addReference()
/*     */     {
/* 470 */       this.counter += 1;
/* 471 */       this.igLog.debug("Counter reference value (++): " + this.counter);
/*     */     }
/*     */ 
/*     */     public int getReferenceCount()
/*     */     {
/* 476 */       return this.counter;
/*     */     }
/*     */ 
/*     */     public void removeReference()
/*     */     {
/* 481 */       this.counter -= 1;
/* 482 */       this.igLog.debug("Counter reference value (--): " + this.counter);
/*     */ 
/* 484 */       if (this.counter <= 0)
/*     */       {
/* 486 */         InvalidationManager.this.removeGroup(this.groupName);
/*     */       }
/*     */     }
/*     */ 
/*     */     public Object getAttribute(String attribute)
/*     */       throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */     {
/* 498 */       if ((attribute == null) || (attribute.equals(""))) {
/* 499 */         throw new IllegalArgumentException("null or empty attribute name");
/*     */       }
/* 501 */       if (attribute.equals("AsynchronousInvalidation")) {
/* 502 */         return new Boolean(this.asynchronous);
/*     */       }
/* 504 */       throw new AttributeNotFoundException(attribute + " is not a known attribute");
/*     */     }
/*     */ 
/*     */     public AttributeList getAttributes(String[] attributes)
/*     */     {
/* 509 */       return null;
/*     */     }
/*     */ 
/*     */     public MBeanInfo getMBeanInfo()
/*     */     {
/* 515 */       MBeanParameterInfo serSimpleParam = new MBeanParameterInfo("key", Serializable.class.getName(), "Primary key to be invalidated");
/*     */ 
/* 521 */       MBeanParameterInfo serArrayParam = new MBeanParameterInfo("keys", [Ljava.io.Serializable.class.getName(), "Primary keys to be invalidated");
/*     */ 
/* 527 */       MBeanParameterInfo asynchParam = new MBeanParameterInfo("asynchronous", Boolean.class.getName(), "Indicates if the invalidation should be asynchronous or must be synchronous");
/*     */ 
/* 533 */       MBeanAttributeInfo[] attrInfo = { new MBeanAttributeInfo("AsynchronousInvalidation", Boolean.class.getName(), "Indicates if invalidation, by default, should be done asynchronously", true, true, false) };
/*     */ 
/* 541 */       MBeanOperationInfo[] opInfo = { new MBeanOperationInfo("invalidate", "invalidate a single key using default (a)synchronous behaviour", new MBeanParameterInfo[] { serSimpleParam }, Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidate", "invalidate a single key indicating the (a)synchronous behaviour", new MBeanParameterInfo[] { serSimpleParam, asynchParam }, Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidate", "invalidate multiple keys using default (a)synchronous behaviour", new MBeanParameterInfo[] { serArrayParam }, Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidate", "invalidate multiple keys indicating the (a)synchronous behaviour", new MBeanParameterInfo[] { serArrayParam, asynchParam }, Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidateAll", "invalidate all keys using default (a)synchronous behaviour", new MBeanParameterInfo[0], Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidateAll", "invalidate all keys with specified (a)synchronous behaviour", new MBeanParameterInfo[] { asynchParam }, Void.TYPE.getName(), 1) };
/*     */ 
/* 579 */       MBeanNotificationInfo[] notifyInfo = null;
/* 580 */       MBeanConstructorInfo[] ctorInfo = new MBeanConstructorInfo[0];
/*     */ 
/* 582 */       return new MBeanInfo(getClass().getName(), "Cache invalidation for group named " + this.groupName, attrInfo, ctorInfo, opInfo, notifyInfo);
/*     */     }
/*     */ 
/*     */     public Object invoke(String actionName, Object[] params, String[] signature)
/*     */       throws MBeanException, ReflectionException
/*     */     {
/* 592 */       if ("invalidate".equals(actionName))
/*     */       {
/* 594 */         if (params.length == 1)
/*     */         {
/* 596 */           if ((params[0] instanceof Serializable[]))
/* 597 */             invalidate((Serializable[])(Serializable[])params[0]);
/* 598 */           else if ((params[0] instanceof Serializable))
/* 599 */             invalidate((Serializable)params[0]);
/*     */           else
/* 601 */             throw new IllegalArgumentException("First argument must be Serializable (or array of)");
/*     */         }
/* 603 */         else if (params.length == 2)
/*     */         {
/* 605 */           if ((params[0] instanceof Serializable[]))
/* 606 */             invalidate((Serializable[])(Serializable[])params[0], ((Boolean)params[1]).booleanValue());
/* 607 */           else if ((params[0] instanceof Serializable))
/* 608 */             invalidate((Serializable)params[0], ((Boolean)params[1]).booleanValue());
/*     */           else {
/* 610 */             throw new IllegalArgumentException("First argument must be Serializable (or array of)");
/*     */           }
/*     */         }
/*     */         else {
/* 614 */           throw new IllegalArgumentException("Unknown operation with these parameters: " + actionName);
/*     */         }
/*     */       }
/* 617 */       else if ("invalidateAll".equals(actionName))
/*     */       {
/* 619 */         if ((params == null) || (params.length == 0))
/*     */         {
/* 621 */           invalidateAll();
/*     */         }
/* 623 */         else if (params.length == 1)
/*     */         {
/* 625 */           invalidateAll(((Boolean)params[1]).booleanValue());
/*     */         }
/*     */         else
/*     */         {
/* 629 */           throw new IllegalArgumentException("invalidateAll can take zero or one parameter but got " + params.length);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 634 */         throw new IllegalArgumentException("Unknown operation: " + actionName);
/*     */       }
/* 636 */       return null;
/*     */     }
/*     */ 
/*     */     public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */     {
/* 641 */       String attrName = attribute.getName();
/* 642 */       if ((attrName == null) || (attrName.equals(""))) {
/* 643 */         throw new IllegalArgumentException("null or empty attribute name");
/*     */       }
/* 645 */       if (attrName.equals("AsynchronousInvalidation"))
/*     */       {
/* 647 */         Object value = attribute.getValue();
/* 648 */         if ((value instanceof Boolean))
/* 649 */           this.asynchronous = ((Boolean)value).booleanValue();
/*     */         else
/* 651 */           throw new InvalidAttributeValueException("Attribute is of boolean type");
/*     */       }
/*     */       else {
/* 654 */         throw new AttributeNotFoundException(attrName + " is not a known attribute");
/*     */       }
/*     */     }
/*     */ 
/*     */     public AttributeList setAttributes(AttributeList attributes) {
/* 659 */       return null;
/*     */     }
/*     */ 
/*     */     protected void localOnlyInvalidate(Serializable[] keys, boolean asynchronous)
/*     */     {
/* 666 */       Iterator iter = this.registered.iterator();
/* 667 */       while (iter.hasNext())
/*     */       {
/* 669 */         Invalidatable inv = (Invalidatable)iter.next();
/* 670 */         inv.areInvalid(keys);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void localOnlyInvalidate(Serializable key, boolean asynchronous)
/*     */     {
/* 676 */       Iterator iter = this.registered.iterator();
/* 677 */       while (iter.hasNext())
/*     */       {
/* 679 */         Invalidatable inv = (Invalidatable)iter.next();
/* 680 */         inv.isInvalid(key);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void localOnlyInvalidateAll()
/*     */     {
/* 687 */       Iterator iter = this.registered.iterator();
/* 688 */       while (iter.hasNext())
/*     */       {
/* 690 */         Invalidatable inv = (Invalidatable)iter.next();
/* 691 */         inv.invalidateAll();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.cache.invalidation.InvalidationManager
 * JD-Core Version:    0.6.0
 */