/*     */ package org.jboss.classloader.plugins;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.security.AccessController;
/*     */ import java.security.CodeSource;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.ProtectionDomain;
/*     */ 
/*     */ public class ClassLoaderUtils
/*     */ {
/*     */   public static final void checkClassName(String className)
/*     */     throws ClassNotFoundException
/*     */   {
/*  48 */     if (className == null)
/*  49 */       throw new ClassNotFoundException("Null class name");
/*  50 */     if (className.trim().length() == 0)
/*  51 */       throw new ClassNotFoundException("Empty class name '" + className + "'");
/*     */   }
/*     */ 
/*     */   public static final String classNameToPath(String className)
/*     */   {
/*  62 */     return className.replace('.', '/') + ".class";
/*     */   }
/*     */ 
/*     */   public static final String packageNameToPath(String className)
/*     */   {
/*  73 */     String packageName = getClassPackageName(className);
/*  74 */     return packageName.replace('.', '/');
/*     */   }
/*     */ 
/*     */   public static final String getClassPackageName(String className)
/*     */   {
/*  85 */     int end = className.lastIndexOf('.');
/*  86 */     if (end == -1)
/*  87 */       return "";
/*  88 */     return className.substring(0, end);
/*     */   }
/*     */ 
/*     */   public static final String getResourcePackageName(String className)
/*     */   {
/*  99 */     int i = className.lastIndexOf('/');
/* 100 */     if (i == -1)
/* 101 */       return "";
/* 102 */     return className.substring(0, i).replace('/', '.');
/*     */   }
/*     */ 
/*     */   public static final byte[] loadByteCode(String name, InputStream is)
/*     */   {
/*     */     try
/*     */     {
/* 116 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 117 */       byte[] tmp = new byte[1024];
/* 118 */       int read = 0;
/* 119 */       while ((read = is.read(tmp)) >= 0)
/* 120 */         baos.write(tmp, 0, read);
/* 121 */       byte[] arrayOfByte1 = baos.toByteArray();
/*     */       return arrayOfByte1;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 125 */       throw new RuntimeException("Unable to load class byte code " + name, e);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 131 */         is.close();
/*     */       }
/*     */       catch (IOException e) {
/*     */       }
/*     */     }
/* 136 */     throw localObject;
/*     */   }
/*     */ 
/*     */   public static final String classToString(Class<?> clazz)
/*     */   {
/* 148 */     if (clazz == null) {
/* 149 */       return "null";
/*     */     }
/* 151 */     StringBuilder builder = new StringBuilder();
/* 152 */     classToString(clazz, builder);
/* 153 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   public static final void classToString(Class<?> clazz, StringBuilder builder)
/*     */   {
/* 164 */     if (clazz == null)
/*     */     {
/* 166 */       builder.append("null");
/* 167 */       return;
/*     */     }
/*     */ 
/* 170 */     builder.append(clazz);
/* 171 */     builder.append('{');
/* 172 */     ClassLoader cl = getClassLoader(clazz);
/* 173 */     builder.append("cl=").append(cl);
/* 174 */     builder.append(" codeSource=");
/* 175 */     builder.append(getCodeSource(clazz));
/* 176 */     builder.append("}");
/*     */   }
/*     */ 
/*     */   private static final ClassLoader getClassLoader(Class<?> clazz)
/*     */   {
/* 187 */     SecurityManager sm = System.getSecurityManager();
/* 188 */     if (sm == null) {
/* 189 */       return clazz.getClassLoader();
/*     */     }
/* 191 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */     {
/*     */       public ClassLoader run()
/*     */       {
/* 195 */         return this.val$clazz.getClassLoader();
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   private static final ProtectionDomain getProtectionDomain(Class<?> clazz)
/*     */   {
/* 208 */     SecurityManager sm = System.getSecurityManager();
/* 209 */     if (sm == null) {
/* 210 */       return clazz.getProtectionDomain();
/*     */     }
/* 212 */     return (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */     {
/*     */       public ProtectionDomain run()
/*     */       {
/* 216 */         return this.val$clazz.getProtectionDomain();
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   private static final CodeSource getCodeSource(Class<?> clazz)
/*     */   {
/* 229 */     ProtectionDomain protectionDomain = getProtectionDomain(clazz);
/* 230 */     if (protectionDomain == null)
/* 231 */       return null;
/* 232 */     return protectionDomain.getCodeSource();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.plugins.ClassLoaderUtils
 * JD-Core Version:    0.6.0
 */