/*    */ package org.jboss.classloader.plugins.filter;
/*    */ 
/*    */ import org.jboss.classloader.spi.filter.ClassFilter;
/*    */ 
/*    */ public class CombiningClassFilter
/*    */   implements ClassFilter
/*    */ {
/*    */   private ClassFilter[] filters;
/*    */ 
/*    */   public static CombiningClassFilter create(ClassFilter[] filters)
/*    */   {
/* 46 */     return new CombiningClassFilter(filters);
/*    */   }
/*    */ 
/*    */   public CombiningClassFilter(ClassFilter[] filters)
/*    */   {
/* 57 */     if (filters == null)
/* 58 */       throw new IllegalArgumentException("Null filters");
/* 59 */     this.filters = filters;
/*    */   }
/*    */ 
/*    */   public boolean matchesClassName(String className)
/*    */   {
/* 64 */     for (ClassFilter filter : this.filters)
/*    */     {
/* 66 */       if (filter.matchesClassName(className))
/* 67 */         return true;
/*    */     }
/* 69 */     return false;
/*    */   }
/*    */ 
/*    */   public boolean matchesResourcePath(String resourcePath)
/*    */   {
/* 74 */     for (ClassFilter filter : this.filters)
/*    */     {
/* 76 */       if (filter.matchesResourcePath(resourcePath))
/* 77 */         return true;
/*    */     }
/* 79 */     return false;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 85 */     StringBuilder builder = new StringBuilder();
/* 86 */     for (int i = 0; i < this.filters.length; i++)
/*    */     {
/* 88 */       builder.append(this.filters[i]);
/* 89 */       if (i < this.filters.length - 1)
/* 90 */         builder.append(", ");
/*    */     }
/* 92 */     return builder.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.plugins.filter.CombiningClassFilter
 * JD-Core Version:    0.6.0
 */