/*     */ package org.jboss.classloader.plugins.loader;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.security.AccessControlContext;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Set;
/*     */ import org.jboss.classloader.spi.Loader;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassLoaderToLoaderAdapter
/*     */   implements Loader
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(ClassLoaderToLoaderAdapter.class);
/*     */   private ClassLoader classLoader;
/*     */   private AccessControlContext accessControlContext;
/*     */ 
/*     */   public ClassLoaderToLoaderAdapter(ClassLoader classLoader)
/*     */   {
/*  61 */     if (classLoader == null)
/*  62 */       throw new IllegalArgumentException("Null classLoader");
/*  63 */     this.classLoader = classLoader;
/*  64 */     this.accessControlContext = AccessController.getContext();
/*     */   }
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/*  70 */     SecurityManager sm = System.getSecurityManager();
/*     */     URL url;
/*     */     URL url;
/*  71 */     if (sm != null)
/*     */     {
/*  73 */       url = (URL)AccessController.doPrivileged(new PrivilegedAction(name)
/*     */       {
/*     */         public URL run()
/*     */         {
/*  77 */           return ClassLoaderToLoaderAdapter.this.classLoader.getResource(this.val$name);
/*     */         }
/*     */       }
/*     */       , this.accessControlContext);
/*     */     }
/*     */     else
/*     */     {
/*  84 */       url = this.classLoader.getResource(name);
/*     */     }
/*     */ 
/*  87 */     if (log.isTraceEnabled())
/*     */     {
/*  89 */       if (url != null)
/*  90 */         log.trace("Resource " + name + " found in " + this.classLoader);
/*     */       else
/*  92 */         log.trace("Resource " + name + " NOT found in " + this.classLoader);
/*     */     }
/*  94 */     return url;
/*     */   }
/*     */ 
/*     */   public void getResources(String name, Set<URL> urls)
/*     */     throws IOException
/*     */   {
/* 100 */     SecurityManager sm = System.getSecurityManager();
/*     */     Enumeration enumeration;
/* 101 */     if (sm != null)
/*     */     {
/*     */       try
/*     */       {
/* 105 */         enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(name)
/*     */         {
/*     */           public Enumeration<URL> run() throws Exception
/*     */           {
/* 109 */             return ClassLoaderToLoaderAdapter.this.classLoader.getResources(this.val$name);
/*     */           }
/*     */         }
/*     */         , this.accessControlContext);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 115 */         Exception e1 = e.getException();
/* 116 */         if ((e1 instanceof RuntimeException))
/* 117 */           throw ((RuntimeException)e1);
/* 118 */         if ((e1 instanceof IOException))
/* 119 */           throw ((IOException)e1);
/* 120 */         IOException e2 = new IOException("Unexpected error");
/* 121 */         e2.initCause(e1);
/* 122 */         throw e2;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 127 */       enumeration = this.classLoader.getResources(name);
/*     */     }
/* 129 */     while (enumeration.hasMoreElements())
/* 130 */       urls.add(enumeration.nextElement());
/*     */   }
/*     */ 
/*     */   public Class<?> loadClass(String className)
/*     */   {
/*     */     try
/*     */     {
/* 137 */       return this.classLoader.loadClass(className);
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 141 */     return null;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 148 */     return this.classLoader.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter
 * JD-Core Version:    0.6.0
 */