/*     */ package org.jboss.classloader.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Set;
/*     */ import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
/*     */ import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
/*     */ import org.jboss.classloader.spi.filter.ClassFilter;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassLoaderDomain extends BaseClassLoaderDomain
/*     */   implements Loader
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(ClassLoaderDomain.class);
/*     */   private String name;
/*  50 */   private ParentPolicy parentPolicy = ParentPolicy.BEFORE;
/*     */   private Loader parent;
/*     */ 
/*     */   public ClassLoaderDomain(String name)
/*     */   {
/*  63 */     if (name == null)
/*  64 */       throw new IllegalArgumentException("Null name");
/*  65 */     this.name = name;
/*  66 */     fixUpParent();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  76 */     return this.name;
/*     */   }
/*     */ 
/*     */   public ParentPolicy getParentPolicy()
/*     */   {
/*  86 */     return this.parentPolicy;
/*     */   }
/*     */ 
/*     */   public void setParentPolicy(ParentPolicy parentPolicy)
/*     */   {
/*  97 */     if (parentPolicy == null)
/*  98 */       throw new IllegalArgumentException("Null parent policy");
/*  99 */     this.parentPolicy = parentPolicy;
/*     */   }
/*     */ 
/*     */   public Loader getParent()
/*     */   {
/* 109 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public void setParent(Loader parent)
/*     */   {
/* 119 */     this.parent = parent;
/* 120 */     fixUpParent();
/*     */   }
/*     */ 
/*     */   protected void toLongString(StringBuilder builder)
/*     */   {
/* 130 */     builder.append("name=").append(getName());
/* 131 */     builder.append(" parentPolicy=").append(getParentPolicy());
/* 132 */     builder.append(" parent=");
/* 133 */     Loader parent = getParent();
/* 134 */     if (parent != null)
/* 135 */       builder.append(parent);
/*     */     else
/* 137 */       builder.append(getParentClassLoader());
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 143 */     StringBuilder builder = new StringBuilder();
/* 144 */     builder.append(getClass().getSimpleName());
/* 145 */     builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
/* 146 */     builder.append("{").append(this.name).append('}');
/* 147 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected Loader findBeforeLoader(String name)
/*     */   {
/* 153 */     boolean trace = log.isTraceEnabled();
/* 154 */     ClassFilter filter = getParentPolicy().getBeforeFilter();
/* 155 */     if (filter.matchesResourcePath(name))
/*     */     {
/* 157 */       if (trace)
/* 158 */         log.trace(this + " " + name + " matches parent beforeFilter=" + filter);
/* 159 */       return findLoaderFromParent(name);
/*     */     }
/* 161 */     if (trace)
/* 162 */       log.trace(this + " " + name + " does NOT match parent beforeFilter=" + filter);
/* 163 */     return null;
/*     */   }
/*     */ 
/*     */   protected Loader findAfterLoader(String name)
/*     */   {
/* 169 */     boolean trace = log.isTraceEnabled();
/* 170 */     ClassFilter filter = getParentPolicy().getAfterFilter();
/* 171 */     if (filter.matchesResourcePath(name))
/*     */     {
/* 173 */       if (trace)
/* 174 */         log.trace(this + " " + name + " matches parent afterFilter=" + filter);
/* 175 */       return findLoaderFromParent(name);
/*     */     }
/* 177 */     if (trace)
/* 178 */       log.trace(this + " " + name + " does NOT match parent afterFilter=" + filter);
/* 179 */     return null;
/*     */   }
/*     */ 
/*     */   protected Loader findLoaderFromParent(String name)
/*     */   {
/* 190 */     Loader parentLoader = getParent();
/*     */ 
/* 192 */     boolean trace = log.isTraceEnabled();
/* 193 */     if (parentLoader == null)
/*     */     {
/* 195 */       if (trace)
/* 196 */         log.trace(this + " not loading from non-existant parent");
/* 197 */       return null;
/*     */     }
/*     */ 
/* 200 */     if (trace) {
/* 201 */       log.trace(this + " load from parent " + name + " parent=" + this.parent);
/*     */     }
/*     */ 
/* 204 */     if ((parentLoader instanceof ClassLoaderDomain))
/*     */     {
/* 206 */       ClassLoaderDomain parentDomain = (ClassLoaderDomain)parentLoader;
/* 207 */       return parentDomain.findLoader(name);
/*     */     }
/*     */ 
/* 211 */     if (parentLoader.getResource(name) != null) {
/* 212 */       return parentLoader;
/*     */     }
/* 214 */     return null;
/*     */   }
/*     */ 
/*     */   protected URL beforeGetResource(String name)
/*     */   {
/* 220 */     boolean trace = log.isTraceEnabled();
/* 221 */     ClassFilter filter = getParentPolicy().getBeforeFilter();
/* 222 */     if (filter.matchesResourcePath(name))
/*     */     {
/* 224 */       if (trace)
/* 225 */         log.trace(this + " " + name + " matches parent beforeFilter=" + filter);
/* 226 */       return getResourceFromParent(name);
/*     */     }
/* 228 */     if (trace)
/* 229 */       log.trace(this + " " + name + " does NOT match parent beforeFilter=" + filter);
/* 230 */     return null;
/*     */   }
/*     */ 
/*     */   protected URL afterGetResource(String name)
/*     */   {
/* 236 */     boolean trace = log.isTraceEnabled();
/* 237 */     ClassFilter filter = getParentPolicy().getAfterFilter();
/* 238 */     if (filter.matchesResourcePath(name))
/*     */     {
/* 240 */       if (trace)
/* 241 */         log.trace(this + " " + name + " matches parent afterFilter=" + filter);
/* 242 */       return getResourceFromParent(name);
/*     */     }
/* 244 */     if (trace)
/* 245 */       log.trace(this + " " + name + " does NOT match parent afterFilter=" + filter);
/* 246 */     return null;
/*     */   }
/*     */ 
/*     */   protected URL getResourceFromParent(String name)
/*     */   {
/* 257 */     Loader parentLoader = getParent();
/*     */ 
/* 259 */     boolean trace = log.isTraceEnabled();
/* 260 */     if (parentLoader == null)
/*     */     {
/* 262 */       if (trace)
/* 263 */         log.trace(this + " not getting resource from non-existant parent");
/* 264 */       return null;
/*     */     }
/*     */ 
/* 267 */     if (trace) {
/* 268 */       log.trace(this + " get resource from parent " + name + " parent=" + parentLoader);
/*     */     }
/* 270 */     URL result = parentLoader.getResource(name);
/*     */ 
/* 272 */     if (trace)
/*     */     {
/* 274 */       if (result != null)
/* 275 */         log.trace(this + " got resource from parent " + name + " parent=" + parentLoader + " " + result);
/*     */       else {
/* 277 */         log.trace(this + " resource not found in parent " + name + " parent=" + parentLoader);
/*     */       }
/*     */     }
/* 280 */     return result;
/*     */   }
/*     */ 
/*     */   protected void beforeGetResources(String name, Set<URL> urls)
/*     */     throws IOException
/*     */   {
/* 286 */     boolean trace = log.isTraceEnabled();
/* 287 */     ClassFilter filter = getParentPolicy().getBeforeFilter();
/* 288 */     if (filter.matchesResourcePath(name))
/*     */     {
/* 290 */       if (trace)
/* 291 */         log.trace(this + " " + name + " matches parent beforeFilter=" + filter);
/* 292 */       getResourcesFromParent(name, urls);
/*     */     }
/* 294 */     else if (trace) {
/* 295 */       log.trace(this + " " + name + " does NOT match parent beforeFilter=" + filter);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void afterGetResources(String name, Set<URL> urls) throws IOException
/*     */   {
/* 301 */     boolean trace = log.isTraceEnabled();
/* 302 */     ClassFilter filter = getParentPolicy().getAfterFilter();
/* 303 */     if (filter.matchesResourcePath(name))
/*     */     {
/* 305 */       if (trace)
/* 306 */         log.trace(this + " " + name + " matches parent afterFilter=" + filter);
/* 307 */       getResourcesFromParent(name, urls);
/*     */     }
/* 309 */     else if (trace) {
/* 310 */       log.trace(this + " " + name + " does NOT match parent afterFilter=" + filter);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void getResourcesFromParent(String name, Set<URL> urls)
/*     */     throws IOException
/*     */   {
/* 322 */     Loader parentLoader = getParent();
/*     */ 
/* 324 */     boolean trace = log.isTraceEnabled();
/* 325 */     if (parentLoader == null)
/*     */     {
/* 327 */       if (trace)
/* 328 */         log.trace(this + " not getting resources from non-existant parent");
/* 329 */       return;
/*     */     }
/*     */ 
/* 332 */     if (trace) {
/* 333 */       log.trace(this + " get resources from parent " + name + " parent=" + parentLoader);
/*     */     }
/* 335 */     parentLoader.getResources(name, urls);
/*     */   }
/*     */ 
/*     */   private void fixUpParent()
/*     */   {
/* 343 */     if (this.parent == null)
/*     */     {
/* 345 */       ClassLoader classLoader = getParentClassLoader();
/* 346 */       if (classLoader != null)
/*     */       {
/* 348 */         this.parent = ((Loader)AccessController.doPrivileged(new PrivilegedAction(classLoader)
/*     */         {
/*     */           public Loader run()
/*     */           {
/* 352 */             return new ClassLoaderToLoaderAdapter(this.val$classLoader);
/*     */           }
/*     */         }));
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.ClassLoaderDomain
 * JD-Core Version:    0.6.0
 */