/*     */ package org.jboss.classloader.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
/*     */ import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
/*     */ import org.jboss.classloader.spi.filter.PackageClassFilter;
/*     */ import org.jboss.classloader.spi.jdk.JDKChecker;
/*     */ import org.jboss.classloader.spi.jdk.JDKCheckerFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class ClassLoaderPolicy extends BaseClassLoaderPolicy
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(ClassLoaderPolicy.class);
/*     */ 
/*     */   protected DelegateLoader getExported()
/*     */   {
/*  67 */     String[] packageNames = getPackageNames();
/*  68 */     if (packageNames == null)
/*  69 */       return null;
/*  70 */     return new FilteredDelegateLoader(this, PackageClassFilter.createPackageClassFilter(packageNames));
/*     */   }
/*     */ 
/*     */   public String[] getPackageNames()
/*     */   {
/*  88 */     return null;
/*     */   }
/*     */ 
/*     */   protected List<? extends DelegateLoader> getDelegates()
/*     */   {
/* 102 */     return Collections.emptyList();
/*     */   }
/*     */ 
/*     */   protected boolean isImportAll()
/*     */   {
/* 114 */     return false;
/*     */   }
/*     */ 
/*     */   protected boolean isCachable()
/*     */   {
/* 126 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean isBlackListable()
/*     */   {
/* 138 */     return true;
/*     */   }
/*     */ 
/*     */   public abstract URL getResource(String paramString);
/*     */ 
/*     */   public InputStream getResourceAsStream(String path)
/*     */   {
/* 159 */     URL url = getResource(path);
/* 160 */     if (url != null)
/*     */     {
/*     */       try
/*     */       {
/* 164 */         return url.openStream();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 168 */         log.debug("Unable to open URL: " + url + " for path " + path + " from " + toLongString());
/*     */       }
/*     */     }
/* 171 */     return null;
/*     */   }
/*     */ 
/*     */   public abstract void getResources(String paramString, Set<URL> paramSet)
/*     */     throws IOException;
/*     */ 
/*     */   protected ProtectionDomain getProtectionDomain(String className, String path)
/*     */   {
/* 196 */     return null;
/*     */   }
/*     */ 
/*     */   public PackageInformation getPackageInformation(String packageName)
/*     */   {
/* 209 */     return null;
/*     */   }
/*     */ 
/*     */   protected ClassLoader isJDKRequest(String name)
/*     */   {
/* 222 */     JDKChecker checker = JDKCheckerFactory.getChecker();
/* 223 */     if (checker.isJDKRequest(name))
/* 224 */       return getSystemClassLoader();
/* 225 */     return null;
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/*     */     try
/*     */     {
/* 237 */       return ObjectName.getInstance("jboss.classloader", "id", "" + System.identityHashCode(this));
/*     */     }
/*     */     catch (MalformedObjectNameException e) {
/*     */     }
/* 241 */     throw new Error("Error creating object name", e);
/*     */   }
/*     */ 
/*     */   protected void toLongString(StringBuilder builder)
/*     */   {
/* 248 */     builder.append(" delegates=").append(getDelegates());
/* 249 */     String[] packageNames = getPackageNames();
/* 250 */     if (packageNames != null)
/* 251 */       builder.append(" exported=").append(Arrays.asList(packageNames));
/* 252 */     boolean importAll = isImportAll();
/* 253 */     if (importAll)
/* 254 */       builder.append(" <IMPORT-ALL>");
/*     */   }
/*     */ 
/*     */   private ClassLoader getSystemClassLoader()
/*     */   {
/* 264 */     SecurityManager sm = System.getSecurityManager();
/* 265 */     if (sm == null) {
/* 266 */       return ClassLoader.getSystemClassLoader();
/*     */     }
/* 268 */     return (ClassLoader)AccessController.doPrivileged(GetSystemClassLoader.INSTANCE, getAccessControlContext());
/*     */   }
/*     */ 
/*     */   private static class GetSystemClassLoader
/*     */     implements PrivilegedAction<ClassLoader>
/*     */   {
/* 276 */     private static GetSystemClassLoader INSTANCE = new GetSystemClassLoader();
/*     */ 
/*     */     public ClassLoader run()
/*     */     {
/* 280 */       return ClassLoader.getSystemClassLoader();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.ClassLoaderPolicy
 * JD-Core Version:    0.6.0
 */