/*    */ package org.jboss.classloader.spi;
/*    */ 
/*    */ import java.net.URL;
/*    */ import java.util.jar.Attributes;
/*    */ import java.util.jar.Attributes.Name;
/*    */ import java.util.jar.Manifest;
/*    */ 
/*    */ public class PackageInformation
/*    */ {
/*    */   public String packageName;
/*    */   public String specTitle;
/*    */   public String specVersion;
/*    */   public String specVendor;
/*    */   public String implTitle;
/*    */   public String implVersion;
/*    */   public String implVendor;
/*    */   public URL sealBase;
/*    */ 
/*    */   public PackageInformation(String packageName)
/*    */   {
/* 69 */     this(packageName, null, null);
/*    */   }
/*    */ 
/*    */   public PackageInformation(String packageName, Manifest manifest)
/*    */   {
/* 81 */     this(packageName, manifest, null);
/*    */   }
/*    */ 
/*    */   public PackageInformation(String packageName, Manifest manifest, URL seal)
/*    */   {
/* 94 */     if (packageName == null) {
/* 95 */       throw new IllegalArgumentException("Null package name");
/*    */     }
/* 97 */     if (manifest != null)
/*    */     {
/* 99 */       String path = packageName.replace('.', '/').concat("/");
/* 100 */       String sealed = null;
/* 101 */       Attributes attributes = manifest.getAttributes(path);
/* 102 */       if (attributes != null)
/*    */       {
/* 104 */         this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
/* 105 */         this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
/* 106 */         this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
/* 107 */         this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
/* 108 */         this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
/* 109 */         this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
/*    */ 
/* 111 */         sealed = attributes.getValue(Attributes.Name.SEALED);
/*    */       }
/* 113 */       attributes = manifest.getMainAttributes();
/* 114 */       if (attributes != null)
/*    */       {
/* 116 */         if (this.specTitle == null)
/*    */         {
/* 118 */           this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
/* 119 */           this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
/* 120 */           this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
/*    */         }
/* 122 */         if (this.implTitle == null)
/*    */         {
/* 124 */           this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
/* 125 */           this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
/* 126 */           this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
/*    */         }
/*    */ 
/* 129 */         if (sealed == null)
/* 130 */           sealed = attributes.getValue(Attributes.Name.SEALED);
/*    */       }
/* 132 */       if ((seal != null) && ("true".equalsIgnoreCase(sealed)))
/* 133 */         this.sealBase = seal;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.PackageInformation
 * JD-Core Version:    0.6.0
 */