/*     */ package org.jboss.classloader.spi.base;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.security.AccessController;
/*     */ import java.security.CodeSource;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import org.jboss.classloader.plugins.ClassLoaderUtils;
/*     */ import org.jboss.classloader.spi.Loader;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ class ClassLoadingTask
/*     */ {
/*  45 */   protected static Logger log = Logger.getLogger("org.jboss.detailed.classloader.ClassLoadinTask");
/*     */   private String className;
/*     */   private Thread requestingThread;
/*     */   private ClassLoader classLoader;
/*     */   private Class<?> loadedClass;
/*     */   private Throwable loadException;
/*     */   private int threadTaskCount;
/*     */   private TaskState state;
/*  87 */   private boolean trace = log.isTraceEnabled();
/*     */   private int numCCE;
/*     */ 
/*     */   ClassLoadingTask(String className, ClassLoader classLoader, Thread requestingThread)
/*     */   {
/* 101 */     this.className = className;
/* 102 */     this.requestingThread = requestingThread;
/* 103 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   String getClassName()
/*     */   {
/* 113 */     return this.className;
/*     */   }
/*     */ 
/*     */   Class<?> getLoadedClass()
/*     */   {
/* 123 */     return this.loadedClass;
/*     */   }
/*     */ 
/*     */   Throwable getLoadException()
/*     */   {
/* 133 */     return this.loadException;
/*     */   }
/*     */ 
/*     */   int getNumCCE()
/*     */   {
/* 143 */     return this.numCCE;
/*     */   }
/*     */ 
/*     */   Thread getRequestingThread()
/*     */   {
/* 153 */     return this.requestingThread;
/*     */   }
/*     */ 
/*     */   synchronized TaskState getState()
/*     */   {
/* 163 */     return this.state;
/*     */   }
/*     */ 
/*     */   synchronized void finish(Class<?> loadedClass)
/*     */   {
/* 173 */     this.loadedClass = loadedClass;
/* 174 */     this.state = TaskState.FINISHED;
/*     */   }
/*     */ 
/*     */   synchronized void foundClassLoader()
/*     */   {
/* 182 */     this.state = TaskState.FOUND_CLASS_LOADER;
/*     */   }
/*     */ 
/*     */   synchronized void finish()
/*     */   {
/* 190 */     this.state = TaskState.FINISHED;
/*     */   }
/*     */ 
/*     */   synchronized void waitOnEvent()
/*     */   {
/* 198 */     this.state = TaskState.WAIT_EVENT;
/*     */   }
/*     */ 
/*     */   synchronized void nextEvent()
/*     */   {
/* 206 */     this.state = TaskState.NEXT_EVENT;
/*     */   }
/*     */ 
/*     */   int getThreadTaskCount()
/*     */   {
/* 216 */     return this.threadTaskCount;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 222 */     StringBuilder builder = new StringBuilder();
/* 223 */     builder.append(getClass().getSimpleName());
/* 224 */     builder.append('@').append(Integer.toHexString(System.identityHashCode(this)));
/* 225 */     builder.append('{');
/* 226 */     builder.append("className=").append(this.className);
/* 227 */     builder.append(" requestingThread=").append(this.requestingThread);
/* 228 */     builder.append(" requestingClassLoader: ").append(this.classLoader);
/* 229 */     if (this.loadedClass != null)
/*     */     {
/* 231 */       builder.append(" loadedClass=");
/* 232 */       ClassLoaderUtils.classToString(this.loadedClass, builder);
/*     */     }
/* 234 */     if (this.loadException != null)
/* 235 */       builder.append(" loadException: ").append(this.loadException);
/* 236 */     builder.append(" threadTaskCount: ").append(this.threadTaskCount);
/* 237 */     builder.append(" state: ").append(this.state);
/* 238 */     if (this.numCCE > 0)
/* 239 */       builder.append(", #CCE: ").append(this.numCCE);
/* 240 */     builder.append('}');
/* 241 */     if ((this.trace) && (this.loadException != null))
/*     */     {
/* 243 */       StringWriter sw = new StringWriter();
/* 244 */       PrintWriter pw = new PrintWriter(sw);
/* 245 */       this.loadException.printStackTrace(pw);
/* 246 */       builder.append("loadException details:\n");
/* 247 */       builder.append(sw.toString());
/*     */     }
/* 249 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   synchronized ThreadTask newThreadTask(Loader loader, Thread thread, boolean reschedule, boolean releaseInNextTask)
/*     */   {
/* 264 */     if (!reschedule)
/* 265 */       this.threadTaskCount += 1;
/* 266 */     return new ThreadTask(loader, thread, releaseInNextTask);
/*     */   }
/*     */ 
/*     */   synchronized void setLoadError(Throwable t)
/*     */   {
/* 276 */     this.threadTaskCount -= 1;
/* 277 */     if (this.trace)
/* 278 */       log.trace("setLoadedError, error=" + t);
/* 279 */     this.loadException = t;
/*     */   }
/*     */ 
/*     */   private synchronized void setLoadedClass(Class<?> theClass)
/*     */   {
/* 292 */     this.threadTaskCount -= 1;
/* 293 */     if (this.trace) {
/* 294 */       log.trace("setLoadedClass, theClass=" + theClass);
/*     */     }
/*     */ 
/* 297 */     if ((this.loadedClass != null) && (theClass != null))
/*     */     {
/* 299 */       StringBuilder builder = new StringBuilder();
/* 300 */       builder.append("Duplicate class found: ").append(this.className).append('\n');
/* 301 */       ProtectionDomain pd = getProtectionDomain(this.loadedClass);
/* 302 */       CodeSource cs = pd != null ? pd.getCodeSource() : null;
/* 303 */       builder.append("Current CS: ").append(cs).append('\n');
/* 304 */       pd = getProtectionDomain(theClass);
/* 305 */       cs = pd != null ? pd.getCodeSource() : null;
/* 306 */       builder.append("Duplicate CS: ").append(cs);
/* 307 */       log.warn(builder.toString());
/*     */     }
/*     */ 
/* 311 */     if ((theClass != null) && (this.loadedClass == null))
/* 312 */       this.loadedClass = theClass;
/*     */   }
/*     */ 
/*     */   private static final ProtectionDomain getProtectionDomain(Class<?> clazz)
/*     */   {
/* 467 */     SecurityManager sm = System.getSecurityManager();
/* 468 */     if (sm == null) {
/* 469 */       return clazz.getProtectionDomain();
/*     */     }
/* 471 */     return (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */     {
/*     */       public ProtectionDomain run()
/*     */       {
/* 475 */         return this.val$clazz.getProtectionDomain();
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   class ThreadTask
/*     */   {
/*     */     private Loader loader;
/*     */     private Thread thread;
/*     */     private boolean releaseInNextTask;
/*     */ 
/*     */     ThreadTask(Loader loader, Thread thread, boolean releaseInNextTask)
/*     */     {
/* 338 */       this.loader = loader;
/* 339 */       this.thread = thread;
/* 340 */       this.releaseInNextTask = releaseInNextTask;
/*     */     }
/*     */ 
/*     */     String getClassName()
/*     */     {
/* 350 */       return ClassLoadingTask.this.className;
/*     */     }
/*     */ 
/*     */     Class<?> getLoadedClass()
/*     */     {
/* 360 */       return ClassLoadingTask.this.loadedClass;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 366 */       StringBuilder builder = new StringBuilder();
/* 367 */       builder.append("{thread=").append(this.thread);
/* 368 */       builder.append(" loader=").append(this.loader);
/* 369 */       builder.append(" requestingThread=").append(ClassLoadingTask.this.requestingThread);
/* 370 */       builder.append(" releaseInNextTask=").append(this.releaseInNextTask);
/* 371 */       builder.append("}");
/* 372 */       return builder.toString();
/*     */     }
/*     */ 
/*     */     ClassLoadingTask getLoadTask()
/*     */     {
/* 382 */       return ClassLoadingTask.this;
/*     */     }
/*     */ 
/*     */     Loader getLoader()
/*     */     {
/* 392 */       return this.loader;
/*     */     }
/*     */ 
/*     */     BaseClassLoader getClassLoader()
/*     */     {
/* 402 */       if ((this.loader instanceof BaseDelegateLoader))
/*     */       {
/* 404 */         BaseDelegateLoader delegateLoader = (BaseDelegateLoader)this.loader;
/* 405 */         return delegateLoader.getPolicy().getClassLoader();
/*     */       }
/* 407 */       return null;
/*     */     }
/*     */ 
/*     */     synchronized Thread getThread()
/*     */     {
/* 417 */       return this.thread;
/*     */     }
/*     */ 
/*     */     synchronized void setThread(Thread thread)
/*     */     {
/* 427 */       this.thread = thread;
/*     */     }
/*     */ 
/*     */     boolean isReleaseInNextTask()
/*     */     {
/* 437 */       return this.releaseInNextTask;
/*     */     }
/*     */ 
/*     */     void run()
/*     */       throws ClassNotFoundException
/*     */     {
/* 447 */       if (ClassLoadingTask.this.loadedClass == null)
/*     */       {
/* 449 */         Class theClass = this.loader.loadClass(ClassLoadingTask.this.className);
/* 450 */         ClassLoadingTask.this.setLoadedClass(theClass);
/*     */       }
/* 452 */       else if (ClassLoadingTask.this.trace)
/*     */       {
/* 454 */         ClassLoadingTask.log.trace("Already found class(" + ClassLoadingTask.this.loadedClass + "), skipping load class");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static enum TaskState
/*     */   {
/*  53 */     FOUND_CLASS_LOADER, 
/*     */ 
/*  56 */     NEXT_EVENT, 
/*     */ 
/*  59 */     WAIT_EVENT, 
/*     */ 
/*  62 */     FINISHED;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.base.ClassLoadingTask
 * JD-Core Version:    0.6.0
 */