/*     */ package org.jboss.classloader.spi.filter;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.Set;
/*     */ import org.jboss.classloader.spi.ClassLoaderPolicy;
/*     */ import org.jboss.classloader.spi.DelegateLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class FilteredDelegateLoader extends DelegateLoader
/*     */ {
/*  41 */   private static final Logger log = Logger.getLogger(FilteredDelegateLoader.class);
/*     */   private ClassFilter filter;
/*     */ 
/*     */   public FilteredDelegateLoader(ClassLoaderPolicy delegate)
/*     */   {
/*  54 */     this(delegate, ClassFilter.EVERYTHING);
/*     */   }
/*     */ 
/*     */   public FilteredDelegateLoader(ClassLoaderPolicy delegate, ClassFilter filter)
/*     */   {
/*  66 */     super(delegate);
/*  67 */     if (filter == null)
/*  68 */       throw new IllegalArgumentException("Null filter");
/*  69 */     this.filter = filter;
/*     */   }
/*     */ 
/*     */   public ClassFilter getFilter()
/*     */   {
/*  79 */     return this.filter;
/*     */   }
/*     */ 
/*     */   public Class<?> loadClass(String className)
/*     */   {
/*  85 */     boolean trace = log.isTraceEnabled();
/*  86 */     if (this.filter.matchesClassName(className))
/*     */     {
/*  88 */       if (trace)
/*  89 */         log.trace(this + " " + className + " matches class filter=" + this.filter);
/*  90 */       return super.loadClass(className);
/*     */     }
/*  92 */     if (trace)
/*  93 */       log.trace(this + " " + className + " does NOT match class filter=" + this.filter);
/*  94 */     return null;
/*     */   }
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/*  99 */     boolean trace = log.isTraceEnabled();
/* 100 */     if (this.filter.matchesResourcePath(name))
/*     */     {
/* 102 */       if (trace)
/* 103 */         log.trace(this + " " + name + " matches resource filter=" + this.filter);
/* 104 */       return super.getResource(name);
/*     */     }
/* 106 */     if (trace)
/* 107 */       log.trace(this + " " + name + " does NOT match resource filter=" + this.filter);
/* 108 */     return null;
/*     */   }
/*     */ 
/*     */   public void getResources(String name, Set<URL> urls) throws IOException
/*     */   {
/* 113 */     boolean trace = log.isTraceEnabled();
/* 114 */     if (this.filter.matchesResourcePath(name))
/*     */     {
/* 116 */       if (trace)
/* 117 */         log.trace(this + " " + name + " matches filter=" + this.filter);
/* 118 */       super.getResources(name, urls);
/*     */     }
/* 120 */     if (trace)
/* 121 */       log.trace(this + " " + name + " does NOT match filter=" + this.filter);
/*     */   }
/*     */ 
/*     */   protected void toLongString(StringBuilder builder)
/*     */   {
/* 127 */     builder.append(" filter=").append(getFilter());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.filter.FilteredDelegateLoader
 * JD-Core Version:    0.6.0
 */