/*    */ package org.jboss.classloader.spi.jdk;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import org.jboss.classloader.plugins.jdk.AbstractJDKChecker;
/*    */ 
/*    */ public class JDKCheckerFactory
/*    */ {
/* 43 */   private static final JDKChecker checker = (JDKChecker)AccessController.doPrivileged(new PrivilegedAction()
/*    */   {
/*    */     public JDKChecker run()
/*    */     {
/* 48 */       String defaultChecker = AbstractJDKChecker.class.getName();
/*    */ 
/* 50 */       String className = System.getProperty(JDKChecker.class.getName(), defaultChecker);
/*    */       try
/*    */       {
/* 53 */         Class clazz = null;
/*    */         try
/*    */         {
/* 56 */           clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
/*    */         }
/*    */         catch (ClassNotFoundException e)
/*    */         {
/*    */           try
/*    */           {
/* 62 */             clazz = getClass().getClassLoader().loadClass(className);
/*    */           }
/*    */           catch (ClassNotFoundException ignored)
/*    */           {
/* 66 */             throw e;
/*    */           }
/*    */         }
/* 69 */         Object result = clazz.newInstance();
/* 70 */         return (JDKChecker)JDKChecker.class.cast(result);
/*    */       }
/*    */       catch (RuntimeException e)
/*    */       {
/* 74 */         throw e;
/*    */       }
/*    */       catch (Exception e) {
/*    */       }
/* 78 */       throw new Error("Unexpected error loading JDKChecker " + className, e);
/*    */     }
/*    */   });
/*    */ 
/*    */   public static JDKChecker getChecker()
/*    */   {
/* 91 */     return checker;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.jdk.JDKCheckerFactory
 * JD-Core Version:    0.6.0
 */