/*     */ package org.jboss.classloader.test.support;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import junit.extensions.TestSetup;
/*     */ import junit.framework.Test;
/*     */ import org.jboss.classloader.plugins.filter.CombiningClassFilter;
/*     */ import org.jboss.classloader.plugins.system.DefaultClassLoaderSystem;
/*     */ import org.jboss.classloader.spi.ClassLoaderDomain;
/*     */ import org.jboss.classloader.spi.ClassLoaderPolicy;
/*     */ import org.jboss.classloader.spi.ClassLoaderSystem;
/*     */ import org.jboss.classloader.spi.DelegateLoader;
/*     */ import org.jboss.classloader.spi.Loader;
/*     */ import org.jboss.classloader.spi.ParentPolicy;
/*     */ import org.jboss.classloader.spi.filter.ClassFilter;
/*     */ import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
/*     */ import org.jboss.classloader.spi.filter.PackageClassFilter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.test.AbstractTestCaseWithSetup;
/*     */ import org.jboss.test.logging.LoggingPlugin;
/*     */ import org.jboss.test.security.PolicyPlugin;
/*     */ 
/*     */ public class IsolatedClassLoaderTestHelper
/*     */ {
/*     */   private ClassLoaderSystem system;
/*     */   private ClassLoaderDomain domain;
/*     */   private ClassLoaderPolicy policy;
/*     */ 
/*     */   public ClassLoaderDomain getDomain()
/*     */   {
/*  75 */     return this.domain;
/*     */   }
/*     */ 
/*     */   public ClassLoaderSystem getSystem()
/*     */   {
/*  85 */     return this.system;
/*     */   }
/*     */ 
/*     */   public ClassLoaderPolicy getPolicy()
/*     */   {
/*  95 */     return this.policy;
/*     */   }
/*     */ 
/*     */   public void setPolicy(ClassLoaderPolicy policy)
/*     */   {
/* 105 */     this.policy = policy;
/*     */   }
/*     */ 
/*     */   public static Set<String> getParentPackages()
/*     */   {
/* 123 */     Set result = new HashSet();
/* 124 */     result.add(Test.class.getPackage().getName());
/* 125 */     result.add(TestSetup.class.getPackage().getName());
/* 126 */     result.add(AbstractTestCaseWithSetup.class.getPackage().getName());
/* 127 */     result.add(Logger.class.getPackage().getName());
/* 128 */     result.add(LoggingPlugin.class.getPackage().getName());
/* 129 */     result.add(PolicyPlugin.class.getPackage().getName());
/* 130 */     result.add(ClassLoaderSystem.class.getPackage().getName());
/* 131 */     result.add(IsolatedClassLoaderTest.class.getPackage().getName());
/*     */ 
/* 133 */     String pkgString = (String)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public String run()
/*     */       {
/* 137 */         return System.getProperty("jboss.test.parent.pkgs");
/*     */       }
/*     */     });
/* 141 */     if (pkgString != null)
/*     */     {
/* 143 */       StringTokenizer tok = new StringTokenizer(pkgString, ",");
/* 144 */       while (tok.hasMoreTokens())
/*     */       {
/* 146 */         String pkg = tok.nextToken();
/* 147 */         result.add(pkg.trim());
/*     */       }
/*     */     }
/*     */ 
/* 151 */     return result;
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, boolean importAll, Class<?>[] packages)
/*     */   {
/* 164 */     MockClassLoaderPolicy policy = new MockClassLoaderPolicy();
/* 165 */     Set classes = new HashSet();
/* 166 */     classes.add(clazz);
/* 167 */     for (Class c : packages)
/* 168 */       classes.add(c);
/* 169 */     policy.setImportAll(importAll);
/* 170 */     policy.setPathsAndPackageNames((Class[])classes.toArray(new Class[classes.size()]));
/*     */ 
/* 172 */     return initializeClassLoader(clazz, policy);
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderPolicy policy)
/*     */   {
/* 184 */     ClassLoaderSystem system = new DefaultClassLoaderSystem();
/* 185 */     return initializeClassLoader(clazz, system, policy, getParentPackages());
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassLoaderPolicy policy)
/*     */   {
/* 198 */     return initializeClassLoader(clazz, system, policy, getParentPackages());
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassLoaderPolicy policy, Set<String> parentPackages)
/*     */   {
/* 212 */     String[] parentPkgs = (String[])parentPackages.toArray(new String[parentPackages.size()]);
/* 213 */     return initializeClassLoader(clazz, system, policy, parentPkgs);
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassLoaderPolicy policy, String[] parentPackages)
/*     */   {
/* 228 */     PackageClassFilter filter = new PackageClassFilter(parentPackages);
/* 229 */     filter.setIncludeJava(true);
/* 230 */     return initializeClassLoader(clazz, system, filter, ClassFilter.NOTHING, policy);
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassFilter parentFilter, boolean importAll, Class<?>[] packages)
/*     */   {
/* 244 */     MockClassLoaderPolicy policy = new MockClassLoaderPolicy();
/* 245 */     Set classes = new HashSet();
/* 246 */     classes.add(clazz);
/* 247 */     for (Class c : packages)
/* 248 */       classes.add(c);
/* 249 */     policy.setImportAll(importAll);
/* 250 */     policy.setPathsAndPackageNames((Class[])classes.toArray(new Class[classes.size()]));
/* 251 */     return initializeClassLoader(clazz, parentFilter, policy);
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassFilter parentFilter, ClassLoaderPolicy policy)
/*     */   {
/* 264 */     ClassLoaderSystem system = new DefaultClassLoaderSystem();
/* 265 */     return initializeClassLoader(clazz, system, parentFilter, policy);
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassFilter parentFilter, ClassLoaderPolicy policy)
/*     */   {
/* 279 */     Set parentPackages = getParentPackages();
/* 280 */     String[] parentPkgs = (String[])parentPackages.toArray(new String[parentPackages.size()]);
/* 281 */     PackageClassFilter filter = new PackageClassFilter(parentPkgs);
/* 282 */     filter.setIncludeJava(true);
/* 283 */     CombiningClassFilter beforeFilter = CombiningClassFilter.create(new ClassFilter[] { filter, parentFilter });
/* 284 */     ParentPolicy parentPolicy = new ParentPolicy(beforeFilter, ClassFilter.NOTHING);
/* 285 */     return initializeClassLoader(clazz, system, parentPolicy, policy);
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassFilter beforeFilter, ClassFilter afterFilter, ClassLoaderPolicy policy)
/*     */   {
/* 300 */     ParentPolicy parentPolicy = new ParentPolicy(beforeFilter, afterFilter);
/* 301 */     return initializeClassLoader(clazz, system, parentPolicy, policy);
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ParentPolicy parentPolicy, ClassLoaderPolicy policy)
/*     */   {
/* 315 */     ClassLoaderDomain domain = system.createAndRegisterDomain("TEST", parentPolicy);
/* 316 */     return initializeClassLoader(clazz, system, domain, policy);
/*     */   }
/*     */ 
/*     */   public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassLoaderDomain domain, ClassLoaderPolicy policy)
/*     */   {
/* 331 */     this.system = system;
/* 332 */     this.domain = domain;
/* 333 */     this.policy = policy;
/*     */ 
/* 336 */     ClassLoader classLoader = system.registerClassLoaderPolicy(domain, policy);
/*     */     try
/*     */     {
/* 341 */       clazz = classLoader.loadClass(clazz.getName());
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 345 */       throw new RuntimeException("Unable to load test class in isolated classloader " + clazz, e);
/*     */     }
/*     */ 
/* 348 */     return clazz;
/*     */   }
/*     */ 
/*     */   public ClassLoader createClassLoader(String name, boolean importAll, String[] packages)
/*     */     throws Exception
/*     */   {
/* 364 */     MockClassLoaderPolicy policy = MockClassLoaderHelper.createMockClassLoaderPolicy(name);
/* 365 */     policy.setImportAll(importAll);
/* 366 */     policy.setPathsAndPackageNames(packages);
/* 367 */     return createClassLoader(policy);
/*     */   }
/*     */ 
/*     */   public ClassLoader createClassLoader(MockClassLoaderPolicy policy)
/*     */     throws Exception
/*     */   {
/* 379 */     ClassLoaderDomain domain = getDomain();
/* 380 */     return createClassLoader(domain, policy);
/*     */   }
/*     */ 
/*     */   public ClassLoader createClassLoader(String domainName, MockClassLoaderPolicy policy)
/*     */     throws Exception
/*     */   {
/* 393 */     ClassLoaderSystem system = getSystem();
/* 394 */     ClassLoaderDomain domain = system.getDomain(domainName);
/* 395 */     return createClassLoader(domain, policy);
/*     */   }
/*     */ 
/*     */   public ClassLoader createClassLoader(ClassLoaderDomain domain, MockClassLoaderPolicy policy)
/*     */     throws Exception
/*     */   {
/* 408 */     ClassLoaderSystem system = getSystem();
/* 409 */     return MockClassLoaderHelper.registerMockClassLoader(system, domain, policy);
/*     */   }
/*     */ 
/*     */   public void unregisterClassLoader(ClassLoader classLoader)
/*     */     throws Exception
/*     */   {
/* 420 */     ClassLoaderSystem system = getSystem();
/* 421 */     system.unregisterClassLoader(classLoader);
/*     */   }
/*     */ 
/*     */   public List<? extends DelegateLoader> createDefaultDelegates()
/*     */   {
/* 431 */     return createDelegates(new ClassLoaderPolicy[] { getPolicy() });
/*     */   }
/*     */ 
/*     */   public List<? extends DelegateLoader> createDelegates(ClassLoaderPolicy[] policies)
/*     */   {
/* 442 */     List delegates = new ArrayList();
/* 443 */     for (ClassLoaderPolicy policy : policies)
/* 444 */       delegates.add(new FilteredDelegateLoader(policy));
/* 445 */     return delegates;
/*     */   }
/*     */ 
/*     */   public ClassLoaderDomain createScopedClassLoaderDomainParentFirst(String name)
/*     */   {
/* 457 */     return createScopedClassLoaderDomain(name, ParentPolicy.BEFORE, getDomain());
/*     */   }
/*     */ 
/*     */   public ClassLoaderDomain createScopedClassLoaderDomainParentLast(String name)
/*     */   {
/* 469 */     return createScopedClassLoaderDomain(name, ParentPolicy.AFTER_BUT_JAVA_BEFORE, getDomain());
/*     */   }
/*     */ 
/*     */   public ClassLoaderDomain createScopedClassLoaderDomain(String name, ParentPolicy parentPolicy)
/*     */   {
/* 481 */     return createScopedClassLoaderDomain(name, parentPolicy, getDomain());
/*     */   }
/*     */ 
/*     */   public ClassLoaderDomain createScopedClassLoaderDomain(String name, ParentPolicy parentPolicy, Loader parent)
/*     */   {
/* 494 */     ClassLoaderSystem system = getSystem();
/* 495 */     return system.createAndRegisterDomain(name, parentPolicy, parent);
/*     */   }
/*     */ 
/*     */   public void unregisterDomain(String name)
/*     */   {
/* 505 */     ClassLoaderSystem system = getSystem();
/* 506 */     ClassLoaderDomain domain = system.getDomain(name);
/* 507 */     if (domain == null)
/* 508 */       throw new IllegalStateException("Domain is not registered: " + name);
/* 509 */     system.unregisterDomain(domain);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.test.support.IsolatedClassLoaderTestHelper
 * JD-Core Version:    0.6.0
 */