/*     */ package org.jboss.crypto;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.Socket;
/*     */ import java.util.Arrays;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.crypto.CipherInputStream;
/*     */ import javax.crypto.CipherOutputStream;
/*     */ import javax.crypto.SecretKey;
/*     */ import javax.crypto.spec.IvParameterSpec;
/*     */ 
/*     */ public class CipherSocket extends Socket
/*     */ {
/*     */   private Cipher cipher;
/*     */   private Socket delegate;
/*     */   String algorithm;
/*     */   SecretKey key;
/*     */ 
/*     */   public CipherSocket(String host, int port, String algorithm, SecretKey key)
/*     */     throws IOException
/*     */   {
/*  50 */     super(host, port);
/*  51 */     this.algorithm = algorithm;
/*  52 */     this.key = key;
/*     */   }
/*     */ 
/*     */   public CipherSocket(Socket delegate, String algorithm, SecretKey key) throws IOException
/*     */   {
/*  57 */     this.delegate = delegate;
/*  58 */     this.algorithm = algorithm;
/*  59 */     this.key = key;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream() throws IOException
/*     */   {
/*  64 */     InputStream is = this.delegate == null ? super.getInputStream() : this.delegate.getInputStream();
/*  65 */     Cipher cipher = null;
/*     */     try
/*     */     {
/*  68 */       cipher = Cipher.getInstance(this.algorithm);
/*  69 */       int size = cipher.getBlockSize();
/*  70 */       byte[] tmp = new byte[size];
/*  71 */       Arrays.fill(tmp, 15);
/*  72 */       IvParameterSpec iv = new IvParameterSpec(tmp);
/*  73 */       cipher.init(2, this.key, iv);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  77 */       e.printStackTrace();
/*  78 */       throw new IOException("Failed to init cipher: " + e.getMessage());
/*     */     }
/*  80 */     CipherInputStream cis = new CipherInputStream(is, cipher);
/*  81 */     return cis;
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream() throws IOException
/*     */   {
/*  86 */     OutputStream os = this.delegate == null ? super.getOutputStream() : this.delegate.getOutputStream();
/*  87 */     Cipher cipher = null;
/*     */     try
/*     */     {
/*  90 */       cipher = Cipher.getInstance(this.algorithm);
/*  91 */       int size = cipher.getBlockSize();
/*  92 */       byte[] tmp = new byte[size];
/*  93 */       Arrays.fill(tmp, 15);
/*  94 */       IvParameterSpec iv = new IvParameterSpec(tmp);
/*  95 */       cipher.init(1, this.key, iv);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  99 */       throw new IOException("Failed to init cipher: " + e.getMessage());
/*     */     }
/* 101 */     CipherOutputStream cos = new CipherOutputStream(os, cipher);
/* 102 */     return cos;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.crypto.CipherSocket
 * JD-Core Version:    0.6.0
 */