/*     */ package org.jboss.dependency.plugins;
/*     */ 
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.LifecycleCallbackItem;
/*     */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractLifecycleCallbackItem
/*     */   implements LifecycleCallbackItem
/*     */ {
/*  39 */   private static final Logger log = Logger.getLogger(AbstractLifecycleCallbackItem.class);
/*     */   ControllerState dependentState;
/*     */   ControllerState whenRequired;
/*     */   String installMethod;
/*     */   String uninstallMethod;
/*     */   String bean;
/*     */   boolean installed;
/*     */ 
/*     */   public AbstractLifecycleCallbackItem(String bean, ControllerState whenRequired, ControllerState dependentState, String installMethod, String uninstallMethod)
/*     */   {
/*  55 */     this.bean = bean;
/*  56 */     this.whenRequired = whenRequired;
/*  57 */     this.dependentState = dependentState;
/*  58 */     this.installMethod = installMethod;
/*  59 */     this.uninstallMethod = uninstallMethod;
/*     */   }
/*     */ 
/*     */   public ControllerState getDependentState()
/*     */   {
/*  64 */     return this.dependentState;
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequired()
/*     */   {
/*  69 */     return this.whenRequired;
/*     */   }
/*     */ 
/*     */   public void install(ControllerContext ctx) throws Exception
/*     */   {
/*  74 */     log.trace("Invoking install callback '" + this.installMethod + "' on " + this.bean + " for target " + this.bean + " at " + this.whenRequired);
/*  75 */     this.installed = true;
/*  76 */     Controller controller = ctx.getController();
/*  77 */     ControllerContext callbackContext = controller.getContext(this.bean, this.dependentState);
/*  78 */     if ((callbackContext instanceof InvokeDispatchContext))
/*     */     {
/*     */       try
/*     */       {
/*  82 */         ((InvokeDispatchContext)callbackContext).invoke(this.installMethod, new Object[] { ctx }, new String[] { ControllerContext.class.getName() });
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*  86 */         throw new Exception("Error calling callback " + this.bean + " for target context " + ctx.getName(), t);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  91 */       throw new IllegalArgumentException("Cannot install " + ctx.getName() + ". Lifecycle callback context " + this.bean + " does not implement InvokeDispatchContext");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void uninstall(ControllerContext ctx)
/*     */   {
/*  97 */     if (this.installed)
/*     */     {
/*  99 */       log.trace("Invoking uninstall callback '" + this.installMethod + "' on " + this.bean + " for target " + this.bean + " at " + this.whenRequired);
/* 100 */       this.installed = false;
/* 101 */       Controller controller = ctx.getController();
/* 102 */       ControllerContext callbackContext = controller.getContext(this.bean, this.dependentState);
/* 103 */       if ((callbackContext instanceof InvokeDispatchContext))
/*     */       {
/*     */         try
/*     */         {
/* 107 */           ((InvokeDispatchContext)callbackContext).invoke(this.uninstallMethod, new Object[] { ctx }, new String[] { ControllerContext.class.getName() });
/*     */         }
/*     */         catch (Throwable ignored)
/*     */         {
/* 111 */           log.warn("Ignored error uninstalling context " + ctx.getName() + "; callback=" + this.bean, ignored);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 116 */         log.warn("Cannot uninstall " + ctx.getName() + ". Lifecycle callback context " + this.bean + " does not implement InvokeDispatchContext");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 123 */     JBossStringBuilder sb = new JBossStringBuilder("LifecycleCallbackItem-");
/* 124 */     sb.append(this.bean);
/* 125 */     sb.append(":");
/* 126 */     sb.append(this.whenRequired);
/* 127 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.AbstractLifecycleCallbackItem
 * JD-Core Version:    0.6.0
 */