/*    */ package org.jboss.dependency.plugins;
/*    */ 
/*    */ import org.jboss.dependency.spi.Controller;
/*    */ import org.jboss.dependency.spi.ControllerContext;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.DependencyInfo;
/*    */ import org.jboss.dependency.spi.DependencyItem;
/*    */ import org.jboss.util.JBossStringBuilder;
/*    */ 
/*    */ public abstract class OwnerCallbackItem<T, C> extends AbstractCallbackItem<T>
/*    */ {
/*    */   protected C owner;
/*    */ 
/*    */   protected OwnerCallbackItem(T name, String attributeName, C owner)
/*    */   {
/* 43 */     this(name, null, null, attributeName, owner);
/*    */   }
/*    */ 
/*    */   protected OwnerCallbackItem(T name, ControllerState whenRequired, ControllerState dependentState, String attributeName, C owner)
/*    */   {
/* 48 */     super(name, whenRequired, dependentState, attributeName);
/* 49 */     if (owner == null)
/* 50 */       throw new IllegalArgumentException("Null owner!");
/* 51 */     this.owner = owner;
/*    */   }
/*    */ 
/*    */   protected void addDependency(Controller controller, ControllerContext context, boolean isInstallPhase)
/*    */   {
/* 63 */     if ((this.owner instanceof ControllerContext))
/*    */     {
/* 65 */       ControllerContext co = (ControllerContext)this.owner;
/* 66 */       DependencyItem dependency = createDependencyItem(co);
/* 67 */       if ((dependency != null) && (dependency.resolve(controller)))
/*    */       {
/* 69 */         context.getDependencyInfo().addDependsOnMe(dependency);
/* 70 */         co.getDependencyInfo().addIDependOn(dependency);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   protected DependencyItem createDependencyItem(ControllerContext owner)
/*    */   {
/* 83 */     return null;
/*    */   }
/*    */ 
/*    */   public void changeCallback(Controller controller, ControllerContext context, boolean isInstallPhase) throws Throwable
/*    */   {
/* 88 */     super.changeCallback(controller, context, isInstallPhase);
/* 89 */     addDependency(controller, context, isInstallPhase);
/*    */   }
/*    */ 
/*    */   protected void toString(JBossStringBuilder buffer)
/*    */   {
/* 94 */     super.toString(buffer);
/* 95 */     buffer.append(" owner=").append(this.owner);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.OwnerCallbackItem
 * JD-Core Version:    0.6.0
 */