/*    */ package org.jboss.dependency.plugins;
/*    */ 
/*    */ import org.jboss.dependency.spi.ControllerContext;
/*    */ 
/*    */ public abstract class ScopedController extends AbstractController
/*    */ {
/*    */   private AbstractController underlyingController;
/*    */ 
/*    */   protected void setUnderlyingController(AbstractController underlyingController)
/*    */   {
/* 40 */     this.underlyingController = underlyingController;
/*    */   }
/*    */ 
/*    */   protected boolean isScoped()
/*    */   {
/* 50 */     return this.underlyingController != null;
/*    */   }
/*    */ 
/*    */   protected void addControllerContext(ControllerContext context)
/*    */   {
/* 55 */     if (isScoped())
/*    */     {
/* 57 */       lockWrite();
/*    */       try
/*    */       {
/* 60 */         this.underlyingController.removeControllerContext(context);
/* 61 */         context.setController(this);
/* 62 */         registerControllerContext(context);
/*    */       }
/*    */       finally
/*    */       {
/* 66 */         unlockWrite();
/*    */       }
/*    */     }
/*    */     else {
/* 70 */       super.addControllerContext(context);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void removeControllerContext(ControllerContext context) {
/* 75 */     if (isScoped())
/*    */     {
/* 77 */       lockWrite();
/*    */       try
/*    */       {
/* 80 */         unregisterControllerContext(context);
/* 81 */         context.setController(this.underlyingController);
/* 82 */         this.underlyingController.addControllerContext(context);
/*    */       }
/*    */       finally
/*    */       {
/* 86 */         unlockWrite();
/*    */       }
/*    */     }
/*    */     else {
/* 90 */       super.removeControllerContext(context);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.ScopedController
 * JD-Core Version:    0.6.0
 */