/*     */ package org.jboss.deployers.plugins.classloading;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.classloader.spi.ClassLoaderDomain;
/*     */ import org.jboss.classloader.spi.ClassLoaderPolicy;
/*     */ import org.jboss.classloader.spi.ClassLoaderSystem;
/*     */ import org.jboss.classloader.spi.ParentPolicy;
/*     */ import org.jboss.classloading.spi.RealClassLoader;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractTopLevelClassLoaderDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractTopLevelClassLoaderSystemDeployer extends AbstractTopLevelClassLoaderDeployer
/*     */ {
/*     */   private ClassLoading classLoading;
/*     */   private ClassLoaderSystem system;
/*     */   private MBeanServer mbeanServer;
/*     */ 
/*     */   public ClassLoading getClassLoading()
/*     */   {
/*  59 */     return this.classLoading;
/*     */   }
/*     */ 
/*     */   public void setClassLoading(ClassLoading classLoading)
/*     */   {
/*  69 */     this.classLoading = classLoading;
/*     */   }
/*     */ 
/*     */   public ClassLoaderSystem getSystem()
/*     */   {
/*  79 */     return this.system;
/*     */   }
/*     */ 
/*     */   public void setSystem(ClassLoaderSystem system)
/*     */   {
/*  89 */     this.system = system;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMbeanServer()
/*     */   {
/*  99 */     return this.mbeanServer;
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer mbeanServer)
/*     */   {
/* 109 */     this.mbeanServer = mbeanServer;
/*     */   }
/*     */ 
/*     */   protected ClassLoader createTopLevelClassLoader(DeploymentContext context)
/*     */     throws Exception
/*     */   {
/* 115 */     if (this.classLoading == null)
/* 116 */       throw new IllegalStateException("The classLoading has not been set");
/* 117 */     if (this.system == null) {
/* 118 */       throw new IllegalStateException("The system has not been set");
/*     */     }
/* 120 */     Module module = (Module)context.getTransientAttachments().getAttachment(Module.class);
/* 121 */     if (module == null) {
/* 122 */       throw new IllegalStateException("Deployment Context has no module: " + context);
/*     */     }
/* 124 */     ClassLoaderPolicy policy = createTopLevelClassLoaderPolicy(context, module);
/*     */     ClassLoaderDomain domain;
/* 127 */     synchronized (this)
/*     */     {
/* 129 */       String domainName = module.getDomainName();
/* 130 */       domain = this.system.getDomain(domainName);
/* 131 */       if (domain == null)
/*     */       {
/* 133 */         ClassLoaderDomain parent = null;
/* 134 */         String parentDomain = module.getParentDomain();
/* 135 */         if (parentDomain != null) {
/* 136 */           parent = this.system.getDomain(parentDomain);
/*     */         }
/* 138 */         ParentPolicy parentPolicy = module.getParentPolicy();
/*     */ 
/* 140 */         domain = this.system.createAndRegisterDomain(domainName, parentPolicy, parent);
/*     */       }
/*     */     }
/* 143 */     ClassLoader classLoader = this.system.registerClassLoaderPolicy(domain, policy);
/*     */     try
/*     */     {
/* 146 */       registerClassLoaderWithMBeanServer(classLoader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 150 */       this.log.warn("Unable to register classloader with mbeanserver: " + classLoader, t);
/*     */     }
/* 152 */     return classLoader;
/*     */   }
/*     */ 
/*     */   protected void removeTopLevelClassLoader(DeploymentContext context)
/*     */     throws Exception
/*     */   {
/* 158 */     ClassLoader classLoader = context.getClassLoader();
/*     */     try
/*     */     {
/* 161 */       unregisterClassLoaderFromMBeanServer(classLoader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 165 */       this.log.warn("Unable to unregister classloader from mbeanserver: " + classLoader, t);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 171 */       this.system.unregisterClassLoader(classLoader);
/*     */     }
/*     */     finally
/*     */     {
/*     */       Module module;
/* 176 */       Module module = (Module)context.getTransientAttachments().getAttachment(Module.class);
/*     */ 
/* 178 */       if (module == null)
/* 179 */         throw new IllegalStateException("Deployment Context has no module: " + context);
/* 180 */       cleanup(context, module);
/* 181 */       module.reset();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void registerClassLoaderWithMBeanServer(ClassLoader classLoader)
/*     */     throws Exception
/*     */   {
/* 193 */     if (this.mbeanServer == null) {
/* 194 */       return;
/*     */     }
/* 196 */     if (!(classLoader instanceof RealClassLoader)) {
/* 197 */       return;
/*     */     }
/* 199 */     RealClassLoader jmxClassLoader = (RealClassLoader)classLoader;
/* 200 */     ObjectName name = jmxClassLoader.getObjectName();
/* 201 */     if (this.mbeanServer.isRegistered(name)) {
/* 202 */       return;
/*     */     }
/* 204 */     this.mbeanServer.registerMBean(classLoader, name);
/*     */   }
/*     */ 
/*     */   protected void unregisterClassLoaderFromMBeanServer(ClassLoader classLoader)
/*     */     throws Exception
/*     */   {
/* 215 */     if (this.mbeanServer == null) {
/* 216 */       return;
/*     */     }
/* 218 */     if (!(classLoader instanceof RealClassLoader)) {
/* 219 */       return;
/*     */     }
/* 221 */     RealClassLoader jmxClassLoader = (RealClassLoader)classLoader;
/* 222 */     ObjectName name = jmxClassLoader.getObjectName();
/* 223 */     if (!this.mbeanServer.isRegistered(name))
/* 224 */       return;
/* 225 */     this.mbeanServer.unregisterMBean(name);
/*     */   }
/*     */ 
/*     */   protected abstract ClassLoaderPolicy createTopLevelClassLoaderPolicy(DeploymentContext paramDeploymentContext, Module paramModule)
/*     */     throws Exception;
/*     */ 
/*     */   protected void cleanup(DeploymentContext context, Module module)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.classloading.AbstractTopLevelClassLoaderSystemDeployer
 * JD-Core Version:    0.6.0
 */