/*     */ package org.jboss.deployers.plugins.classloading;
/*     */ 
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStage;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*     */ import org.jboss.deployers.structure.spi.classloading.Requirement;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class RequirementDependencyItem extends AbstractDependencyItem
/*     */ {
/*  40 */   private static final ControllerState CLASSLOADER = new ControllerState(DeploymentStages.CLASSLOADER.getName());
/*     */   private Module module;
/*     */   private Requirement requirement;
/*     */ 
/*     */   public RequirementDependencyItem(Module module, Requirement requirement)
/*     */   {
/*  57 */     super(module != null ? module.getName() : null, null, CLASSLOADER, CLASSLOADER);
/*  58 */     if (module == null)
/*  59 */       throw new IllegalArgumentException("Null module");
/*  60 */     if (requirement == null)
/*  61 */       throw new IllegalArgumentException("Null requirement");
/*  62 */     this.module = module;
/*  63 */     this.requirement = requirement;
/*     */   }
/*     */ 
/*     */   public boolean resolve(Controller controller)
/*     */   {
/*  68 */     Object iDependOn = this.module.resolve(controller, this.requirement);
/*  69 */     if (iDependOn != null)
/*     */     {
/*  71 */       ControllerContext context = controller.getContext(iDependOn, CLASSLOADER);
/*  72 */       if (context != null)
/*     */       {
/*  74 */         setIDependOn(context.getName());
/*  75 */         addDependsOnMe(controller, context);
/*  76 */         setResolved(true);
/*     */       }
/*     */       else
/*     */       {
/*  80 */         setResolved(false);
/*     */       }
/*     */     }
/*  83 */     return isResolved();
/*     */   }
/*     */ 
/*     */   public void unresolved()
/*     */   {
/*  88 */     setIDependOn(null);
/*  89 */     setResolved(false);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/*  94 */     super.toString(buffer);
/*  95 */     buffer.append(" requirement=").append(this.requirement);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 100 */     buffer.append(getName()).append(" ").append(this.requirement);
/*     */   }
/*     */ 
/*     */   public String toHumanReadableString()
/*     */   {
/* 105 */     return this.requirement.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.classloading.RequirementDependencyItem
 * JD-Core Version:    0.6.0
 */