/*     */ package org.jboss.deployers.plugins.structure;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.spi.attachments.helpers.PredeterminedManagedObjectAttachmentsImpl;
/*     */ import org.jboss.deployers.spi.structure.ClassPathEntry;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ 
/*     */ public class ContextInfoImpl extends PredeterminedManagedObjectAttachmentsImpl
/*     */   implements ContextInfo, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -4384869824260284607L;
/*     */   private String path;
/*     */   private List<String> metaDataPath;
/*  57 */   private List<ClassPathEntry> classPath = ClassPathEntryImpl.DEFAULT;
/*     */ 
/*  59 */   private int relativeOrder = 0;
/*     */   private String comparatorClassName;
/*     */ 
/*     */   public ContextInfoImpl()
/*     */   {
/*  69 */     setPath("");
/*     */   }
/*     */ 
/*     */   public ContextInfoImpl(String path)
/*     */   {
/*  80 */     setPath(path);
/*     */   }
/*     */ 
/*     */   public ContextInfoImpl(String path, List<ClassPathEntry> classPath)
/*     */   {
/*  92 */     setPath(path);
/*  93 */     setClassPath(classPath);
/*     */   }
/*     */ 
/*     */   public ContextInfoImpl(String path, String metaDataPath, List<ClassPathEntry> classPath)
/*     */   {
/* 106 */     setPath(path);
/* 107 */     if (metaDataPath == null)
/* 108 */       throw new IllegalArgumentException("Null metadata path.");
/* 109 */     setMetaDataPath(Collections.singletonList(metaDataPath));
/* 110 */     setClassPath(classPath);
/*     */   }
/*     */ 
/*     */   public ContextInfoImpl(String path, List<String> metaDataPath, List<ClassPathEntry> classPath)
/*     */   {
/* 123 */     setPath(path);
/* 124 */     setMetaDataPath(metaDataPath);
/* 125 */     setClassPath(classPath);
/*     */   }
/*     */ 
/*     */   public String getPath()
/*     */   {
/* 130 */     return this.path;
/*     */   }
/*     */ 
/*     */   public void setPath(String path)
/*     */   {
/* 141 */     if (path == null)
/* 142 */       throw new IllegalArgumentException("Null path");
/* 143 */     this.path = path;
/*     */   }
/*     */ 
/*     */   public List<String> getMetaDataPath()
/*     */   {
/* 148 */     if (this.metaDataPath == null)
/* 149 */       return Collections.emptyList();
/* 150 */     return this.metaDataPath;
/*     */   }
/*     */ 
/*     */   public void setMetaDataPath(List<String> metaDataPath)
/*     */   {
/* 160 */     this.metaDataPath = metaDataPath;
/*     */   }
/*     */ 
/*     */   public void addMetaDataPath(String path)
/*     */   {
/* 165 */     if (path == null) {
/* 166 */       throw new IllegalArgumentException("Null path");
/*     */     }
/* 168 */     if (this.metaDataPath == null) {
/* 169 */       this.metaDataPath = Collections.singletonList(path);
/* 170 */     } else if (this.metaDataPath.size() == 1)
/*     */     {
/* 172 */       List paths = new ArrayList();
/* 173 */       paths.addAll(this.metaDataPath);
/* 174 */       paths.add(path);
/* 175 */       this.metaDataPath = paths;
/*     */     }
/*     */     else {
/* 178 */       this.metaDataPath.add(path);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List<ClassPathEntry> getClassPath() {
/* 183 */     return this.classPath;
/*     */   }
/*     */ 
/*     */   public void setClassPath(List<ClassPathEntry> classPath)
/*     */   {
/* 193 */     this.classPath = classPath;
/*     */   }
/*     */ 
/*     */   public void addClassPathEntry(ClassPathEntry entry)
/*     */   {
/* 198 */     if (entry == null) {
/* 199 */       throw new IllegalArgumentException("Null entry");
/*     */     }
/* 201 */     if ((this.classPath == null) || (this.classPath == ClassPathEntryImpl.DEFAULT))
/*     */     {
/* 203 */       List old = this.classPath;
/* 204 */       this.classPath = new ArrayList();
/* 205 */       if (old != null)
/* 206 */         this.classPath.addAll(old);
/*     */     }
/* 208 */     this.classPath.add(entry);
/*     */   }
/*     */ 
/*     */   public String getComparatorClassName()
/*     */   {
/* 213 */     return this.comparatorClassName;
/*     */   }
/*     */ 
/*     */   public void setComparatorClassName(String className)
/*     */   {
/* 218 */     this.comparatorClassName = className;
/*     */   }
/*     */ 
/*     */   public int getRelativeOrder()
/*     */   {
/* 223 */     return this.relativeOrder;
/*     */   }
/*     */ 
/*     */   public void setRelativeOrder(int relativeOrder)
/*     */   {
/* 228 */     this.relativeOrder = relativeOrder;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 234 */     StringBuilder builder = new StringBuilder();
/* 235 */     builder.append(getClass().getSimpleName());
/* 236 */     builder.append("{");
/* 237 */     toString(builder);
/* 238 */     builder.append("}");
/* 239 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void toString(StringBuilder builder)
/*     */   {
/* 249 */     builder.append("path=").append(getPath());
/* 250 */     builder.append(" metaData=").append(getMetaDataPath());
/* 251 */     builder.append(" classPath=").append(getClassPath());
/* 252 */     if (this.relativeOrder != 0)
/* 253 */       builder.append(" relativeOrder=").append(getRelativeOrder());
/* 254 */     if (this.comparatorClassName != null)
/* 255 */       builder.append(" comparator=").append(getComparatorClassName());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 261 */     if (obj == this)
/* 262 */       return true;
/* 263 */     if ((obj == null) || (!(obj instanceof Externalizable))) {
/* 264 */       return false;
/*     */     }
/* 266 */     ContextInfo other = (Externalizable)obj;
/* 267 */     if (!getPath().equals(other.getPath())) {
/* 268 */       return false;
/*     */     }
/* 270 */     List thisMetaDataPath = getMetaDataPath();
/* 271 */     List otherMetaDataPath = other.getMetaDataPath();
/* 272 */     if (!thisMetaDataPath.equals(otherMetaDataPath)) {
/* 273 */       return false;
/*     */     }
/* 275 */     List thisClassPath = getClassPath();
/* 276 */     List otherClassPath = other.getClassPath();
/* 277 */     if (thisClassPath == null)
/* 278 */       return otherClassPath == null;
/* 279 */     return thisClassPath.equals(otherClassPath);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 285 */     return getPath().hashCode();
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 291 */     super.readExternal(in);
/* 292 */     setPath(in.readUTF());
/* 293 */     boolean isEmptyMetaDataPath = in.readBoolean();
/* 294 */     if (!isEmptyMetaDataPath)
/* 295 */       setMetaDataPath((List)in.readObject());
/* 296 */     setClassPath((List)in.readObject());
/* 297 */     setRelativeOrder(in.readInt());
/* 298 */     boolean isNullComparator = in.readBoolean();
/* 299 */     if (!isNullComparator)
/* 300 */       setComparatorClassName(in.readUTF());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 312 */     super.writeExternal(out);
/* 313 */     out.writeUTF(getPath());
/* 314 */     List metaDataPath = getMetaDataPath();
/* 315 */     boolean isEmptyMetaDataPath = metaDataPath.isEmpty();
/* 316 */     out.writeBoolean(isEmptyMetaDataPath);
/* 317 */     if (!isEmptyMetaDataPath)
/* 318 */       out.writeObject(metaDataPath);
/* 319 */     out.writeObject(getClassPath());
/* 320 */     out.writeInt(getRelativeOrder());
/* 321 */     String comparator = getComparatorClassName();
/* 322 */     boolean isNullComparator = comparator == null;
/* 323 */     out.writeBoolean(isNullComparator);
/* 324 */     if (!isNullComparator)
/* 325 */       out.writeUTF(comparator);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.structure.ContextInfoImpl
 * JD-Core Version:    0.6.0
 */