/*     */ package org.jboss.deployers.spi.deployer.helpers;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ 
/*     */ public abstract class AbstractComponentDeployer<D, C> extends AbstractRealDeployerWithInput<D>
/*     */ {
/*     */   private DeploymentVisitor<C> compVisitor;
/*     */ 
/*     */   public AbstractComponentDeployer()
/*     */   {
/*  47 */     setAllInputs(true);
/*     */   }
/*     */ 
/*     */   public Class<? extends C> getOutput()
/*     */   {
/*  53 */     Class output = super.getOutput();
/*  54 */     if (output == null)
/*  55 */       throw new IllegalStateException("No output for " + this);
/*  56 */     return output;
/*     */   }
/*     */ 
/*     */   protected void setComponentVisitor(DeploymentVisitor<C> visitor)
/*     */   {
/*  67 */     if (visitor == null)
/*  68 */       throw new IllegalArgumentException("Null visitor");
/*  69 */     this.compVisitor = visitor;
/*  70 */     Class componentType = visitor.getVisitorType();
/*  71 */     if (componentType == null)
/*  72 */       throw new IllegalArgumentException("Null visitor type");
/*  73 */     setOutput(componentType);
/*  74 */     addInput(componentType);
/*     */   }
/*     */ 
/*     */   public void internalDeploy(DeploymentUnit unit) throws DeploymentException
/*     */   {
/*  79 */     super.internalDeploy(unit);
/*     */     try
/*     */     {
/*  83 */       deployComponents(unit);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  87 */       undeployComponents(unit);
/*  88 */       throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + unit.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void internalUndeploy(DeploymentUnit unit)
/*     */   {
/*  94 */     super.internalUndeploy(unit);
/*  95 */     undeployComponents(unit);
/*     */   }
/*     */ 
/*     */   protected void deployComponents(DeploymentUnit unit) throws DeploymentException
/*     */   {
/* 100 */     if (this.compVisitor == null) {
/* 101 */       return;
/*     */     }
/* 103 */     Set components = unit.getAllMetaData(getOutput());
/* 104 */     for (Iterator i$ = components.iterator(); i$.hasNext(); ) { Object component = i$.next();
/* 105 */       this.compVisitor.deploy(unit, component); }
/*     */   }
/*     */ 
/*     */   protected void undeployComponents(DeploymentUnit unit)
/*     */   {
/* 110 */     if (this.compVisitor == null) {
/* 111 */       return;
/*     */     }
/* 113 */     Set components = unit.getAllMetaData(getOutput());
/* 114 */     for (Iterator i$ = components.iterator(); i$.hasNext(); ) { Object component = i$.next();
/* 115 */       this.compVisitor.undeploy(unit, component);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer
 * JD-Core Version:    0.6.0
 */