/*    */ package org.jboss.deployers.spi.deployer.helpers;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ 
/*    */ public abstract class AbstractOptionalRealDeployer<T> extends AbstractRealDeployer
/*    */ {
/*    */   private Class<T> optionalInput;
/*    */ 
/*    */   public AbstractOptionalRealDeployer(Class<T> optionalInput)
/*    */   {
/* 50 */     if (optionalInput == null)
/* 51 */       throw new IllegalArgumentException("Null optional Input");
/* 52 */     this.optionalInput = optionalInput;
/* 53 */     setInputs(new Class[] { optionalInput });
/*    */   }
/*    */ 
/*    */   public void internalDeploy(DeploymentUnit unit) throws DeploymentException
/*    */   {
/* 58 */     deploy(unit, unit.getAttachment(this.optionalInput));
/*    */   }
/*    */ 
/*    */   public abstract void deploy(DeploymentUnit paramDeploymentUnit, T paramT)
/*    */     throws DeploymentException;
/*    */ 
/*    */   public void internalUndeploy(DeploymentUnit unit)
/*    */   {
/* 74 */     undeploy(unit, unit.getAttachment(this.optionalInput));
/*    */   }
/*    */ 
/*    */   public void undeploy(DeploymentUnit unit, T deployment)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.helpers.AbstractOptionalRealDeployer
 * JD-Core Version:    0.6.0
 */