/*     */ package org.jboss.deployers.structure.spi.classloading;
/*     */ 
/*     */ public class VersionRange
/*     */ {
/*     */   private Version low;
/*     */   private boolean lowInclusive;
/*     */   private Version high;
/*     */   private boolean highInclusive;
/*  45 */   public static final VersionRange ALL_VERSIONS = new VersionRange(Version.DEFAULT_VERSION);
/*     */ 
/*     */   public VersionRange(Version low)
/*     */   {
/*  54 */     this(low, null);
/*     */   }
/*     */ 
/*     */   public VersionRange(Version low, Version high)
/*     */   {
/*  65 */     this(low, true, high, false);
/*     */   }
/*     */ 
/*     */   public VersionRange(Version low, boolean lowInclusive, Version high, boolean highInclusive)
/*     */   {
/*  78 */     this.low = low;
/*  79 */     this.lowInclusive = lowInclusive;
/*  80 */     this.high = high;
/*  81 */     this.highInclusive = highInclusive;
/*     */   }
/*     */ 
/*     */   public Version getLow()
/*     */   {
/*  91 */     return this.low;
/*     */   }
/*     */ 
/*     */   public boolean isLowInclusive()
/*     */   {
/* 101 */     return this.lowInclusive;
/*     */   }
/*     */ 
/*     */   public Version getHigh()
/*     */   {
/* 111 */     return this.high;
/*     */   }
/*     */ 
/*     */   public boolean isHighInclusive()
/*     */   {
/* 121 */     return this.highInclusive;
/*     */   }
/*     */ 
/*     */   public boolean isInRange(Version version)
/*     */   {
/* 133 */     if (version == null) {
/* 134 */       throw new IllegalArgumentException("Null version");
/*     */     }
/*     */ 
/* 137 */     if (this.low != null)
/*     */     {
/* 139 */       int comparison = this.low.compareTo(version);
/* 140 */       if (comparison < 0)
/* 141 */         return false;
/* 142 */       if ((!this.lowInclusive) && (comparison == 0))
/* 143 */         return false;
/*     */     }
/* 145 */     if (this.high != null)
/*     */     {
/* 147 */       int comparison = this.high.compareTo(version);
/* 148 */       if (comparison > 0)
/* 149 */         return false;
/* 150 */       if ((!this.highInclusive) && (comparison == 0))
/* 151 */         return false;
/*     */     }
/* 153 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 159 */     if (obj == this)
/* 160 */       return true;
/* 161 */     if ((obj == null) || (!(obj instanceof VersionRange))) {
/* 162 */       return false;
/*     */     }
/* 164 */     VersionRange other = (VersionRange)obj;
/*     */ 
/* 166 */     Version thisLow = other.getLow();
/* 167 */     Version otherLow = other.getLow();
/* 168 */     if (thisLow == null)
/*     */     {
/* 170 */       if (otherLow != null)
/* 171 */         return false;
/*     */     }
/* 173 */     else if (!thisLow.equals(otherLow)) {
/* 174 */       return false;
/*     */     }
/* 176 */     if ((thisLow != null) && (isLowInclusive() != other.isLowInclusive())) {
/* 177 */       return false;
/*     */     }
/* 179 */     Version thisHigh = other.getHigh();
/* 180 */     Version otherHigh = other.getHigh();
/* 181 */     if (thisHigh == null)
/*     */     {
/* 183 */       if (otherHigh != null)
/* 184 */         return false;
/*     */     }
/* 186 */     else if (!thisHigh.equals(otherHigh)) {
/* 187 */       return false;
/*     */     }
/*     */ 
/* 190 */     return (thisHigh == null) || (isHighInclusive() == other.isHighInclusive());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 198 */     if (this.low != null)
/* 199 */       return this.low.hashCode();
/* 200 */     if (this.high != null)
/* 201 */       return this.high.hashCode();
/* 202 */     return 0;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 208 */     StringBuilder builder = new StringBuilder();
/* 209 */     if (this.low != null)
/*     */     {
/* 211 */       if (isLowInclusive())
/* 212 */         builder.append("[");
/*     */       else
/* 214 */         builder.append("(");
/* 215 */       builder.append(this.low);
/*     */     }
/*     */     else
/*     */     {
/* 219 */       builder.append("[").append(Version.DEFAULT_VERSION);
/*     */     }
/* 221 */     builder.append(",");
/* 222 */     if (this.high != null)
/*     */     {
/* 224 */       builder.append(this.high);
/* 225 */       if (isHighInclusive())
/* 226 */         builder.append("]");
/*     */       else
/* 228 */         builder.append(")");
/*     */     }
/*     */     else
/*     */     {
/* 232 */       builder.append("inf)");
/*     */     }
/* 234 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.classloading.VersionRange
 * JD-Core Version:    0.6.0
 */