/*     */ package org.jboss.deployers.structure.spi.classloading.helpers;
/*     */ 
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.classloading.PackageCapability;
/*     */ import org.jboss.deployers.structure.spi.classloading.RequirePackage;
/*     */ import org.jboss.deployers.structure.spi.classloading.Requirement;
/*     */ import org.jboss.deployers.structure.spi.classloading.Version;
/*     */ import org.jboss.deployers.structure.spi.classloading.VersionRange;
/*     */ 
/*     */ public class PackageCapabilityImpl
/*     */   implements PackageCapability
/*     */ {
/*     */   private static final long serialVersionUID = -1586959469453286396L;
/*     */   private String name;
/*     */   private Version version;
/*     */ 
/*     */   public PackageCapabilityImpl(String name)
/*     */   {
/*  55 */     this(name, null);
/*     */   }
/*     */ 
/*     */   public PackageCapabilityImpl(String name, Version version)
/*     */   {
/*  67 */     if (name == null)
/*  68 */       throw new IllegalArgumentException("Null name");
/*  69 */     if (version == null)
/*  70 */       version = Version.DEFAULT_VERSION;
/*  71 */     this.name = name;
/*  72 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  78 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Version getVersion()
/*     */   {
/*  83 */     return this.version;
/*     */   }
/*     */ 
/*     */   public boolean resolves(DeploymentUnit unit, Requirement requirement)
/*     */   {
/*  88 */     if (!(requirement instanceof RequirePackage))
/*  89 */       return false;
/*  90 */     RequirePackage requirePackage = (RequirePackage)requirement;
/*  91 */     if (!getName().equals(requirePackage.getName()))
/*  92 */       return false;
/*  93 */     return requirePackage.getVersionRange().isInRange(getVersion());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  99 */     if (obj == this)
/* 100 */       return true;
/* 101 */     if ((obj == null) || (!(obj instanceof PackageCapability)))
/* 102 */       return false;
/* 103 */     PackageCapability other = (PackageCapability)obj;
/* 104 */     if (!getName().equals(other.getName()))
/* 105 */       return false;
/* 106 */     return getVersion().equals(other.getVersion());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 112 */     return getName().hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 118 */     return "Package: " + getName() + ":" + getVersion();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.classloading.helpers.PackageCapabilityImpl
 * JD-Core Version:    0.6.0
 */